/**
 * @(#)CsPhysicsWarehouseRespDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

//
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
* @Description CsPhysicsWarehouseRespDto
*
* @author jingran
* @Date: 2021/12/29 11:15
* @since 1.0.0
*/
@ApiModel(value = "csPhysicsWarehouseRespDto", description = "返回信息Dto")
public class CsPhysicsWarehouseRespDto extends BaseRespDto {
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓 */
    @ApiModelProperty(name="warehouseType",value = "仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓")
    private String warehouseType;
    /** 仓库状态 initial-初始,enable-启用,disable-停用 */
    @ApiModelProperty(name="warehouseStatus",value = "仓库状态 initial-初始,enable-启用,disable-停用")
    private String warehouseStatus;
    /**
     * 是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用
     */
    @ApiModelProperty(name = "rdcFlag", value = "是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用")
    private String rdcFlag;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRdcFlag() {
        return rdcFlag;
    }

    public void setRdcFlag(String rdcFlag) {
        this.rdcFlag = rdcFlag;
    }
}
