package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.ResponseDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.MqMessageRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
* MQ报文（发货/收货通知单）服务接口
*
* @author 杰俊
* @since 2021-09-28
*/
@Api(tags = {"MQ报文（发货/收货通知单）服务"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}", path = "/v1/mqMessage", url = "${yundt.cube.center.inventory.api:}")
public interface IMqMessageQueryApi {

    /**
    * 根据id查询MQ报文（发货/收货通知单）
    *
    * @param messageKey MQ报文（发货/收货通知单）id
    * @return   MQ报文（发货/收货通知单）数据
    */
    @GetMapping("/queryById")
    @ApiOperation(value = "根据id查询MQ报文（发货/收货通知单）", notes = "根据id查询MQ报文（发货/收货通知单）")
    ResponseDto queryById(@RequestParam("messageKey") Long messageKey);

    /**
     * 根据单号查询MQ报文
     *
     * @param noList 订单集合
     * @return   MQ报文（发货/收货通知单）数据
     */
    @PostMapping("/queryByNo")
    @ApiOperation(value = "根据单号查询MQ报文", notes = "根据单号查询MQ报文")
    RestResponse<List<MqMessageRespDto>> queryByNo(@RequestBody List<String> noList);

}
