package com.dtyunxi.yundt.cube.center.inventory.dto.base.resp;

import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author shuidi
 * @Description TyWarehouseRespDto
 * @Date: 2020/01/03 17:20
 * @since 1.0.0
 */
@ApiModel(value = "BaseOrderRespDto", description = "返回信息Dto")
@Data
public class BaseOrderRespDto {

    /**
     * 结果单号 查询
     */
    @ApiModelProperty(name = "no", value = "结果单号")
    private String no;
    /**
     * 仓库Id
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库Id")
    private String warehouseId;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     * 仓库名称 查询
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;


    private String strStatus;

    public String getStrStatus() {
        if (status.equals(OrderStatus.DELIVERY_WAIT_AUDIT)) return "待审核";
        else if (status.equals(OrderStatus.DELIVERY_OUT)) return "出库";
        else if (status.equals(OrderStatus.DELIVERY_OUT_FINISH)) return "已完成";
        else if (status.equals(OrderStatus.DELIVERY_CANCEL)) return "已取消";
        else if (status.equals(OrderStatus.RECIPT_WAIT_AUDIT)) return "待审核";
        else if (status.equals(OrderStatus.RECIPT_WAIT_DELIVER)) return "待配发";
        else if (status.equals(OrderStatus.RECIPT_DELIVERED)) return "已配发";
        else if (status.equals(OrderStatus.RECIPT_WAIT_RECEIVE)) return "待收货";
        else if (status.equals(OrderStatus.RECIPT_FINISH)) return "已完成";
        else if (status.equals(OrderStatus.RECIPT_CANCEL)) return "已取消";
        else if (status.equals(OrderStatus.RECIPT_ING)) return "入库中";
        else if (status.equals(OrderStatus.ADJUST_WAIT_AUDIT)) return "待审核";
        else if (status.equals(OrderStatus.ADJUST_FINISH)) return "已调整";
        else if (status.equals(OrderStatus.ADJUST_REFUSE)) return "审批拒绝";
        else return "--";
    }

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date createTime;
}
