/**
 * @(#)CsInNoticeOrderApi.java 1.0 2021/12/29 11:10
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * CsInNoticeOrderApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:10
 * @since 1.0.0
 */
@Api(tags = {"CsInNoticeOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInNoticeOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInNoticeOrderApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsInNoticeOrderAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsInNoticeOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    /**
     * 根据收货通知单号，创建入库通知单
     *
     * @param relevanceNo 收货通知单号
     * @return 出库通知单id
     */
    @GetMapping(value = "/createInNoticeOrder", produces = "application/json")
    @ApiOperation(value = "根据收货通知单号，创建入库通知单", notes = "根据收货通知单号，创建入库通知单")
    RestResponse<Long> createInNoticeOrder(String relevanceNo);

}