package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
* 客户仓库配置表Eo对象
*
* @author Ghosn
* @since 2024-10-31
*/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "WarehouseSupplyRelReqDto", description = "客户仓库配置表Eo对象")
public class WarehouseSupplyRelReqDto extends RequestDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;

    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "是否主仓库")
    private Integer mainWarehouse;

    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
    *  所属组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;
    /**
    *  关系状态
    */
    @ApiModelProperty(name = "status", value = "关系状态")
    private Integer status;
    /**
    *  客户ID
    */
    @ApiModelProperty(name = "customerId", value = "客户ID")
    private Long customerId;
    /**
     *  客户ID
     */
    @ApiModelProperty(name = "customerIds", value = "客户ID")
    private List<Long> customerIds;

    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;

    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "warehouseCodeList", value = "仓库编码")
    private List<String> warehouseCodeList;

    /**
     *  组织ID
     */
    @ApiModelProperty(name = "organizationIdList", value = "组织ID")
    private List<Long> organizationIdList;

    @ApiModelProperty(name = "customerShortCode", value = "客户编码截取前面，做分仓规则匹配")
    private String customerShortCode;

}
