/**
 * @(#)CsInventoryOperateLogRespDto.java 1.0 2022/03/07 14:52
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsInventoryOperateLogRespDto
*
* @author jingran
* @Date: 2022/03/07 14:52
* @since 1.0.0
*/
@ApiModel(value = "csInventoryOperateLogRespDto", description = "返回信息Dto")
public class CsInventoryOperateLogRespDto implements Serializable {

    /** 版本号 */
    @ApiModelProperty(name="version",value = "版本号")
    private String version;
    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /** 仓库对应于不同层级仓库的类型 */
    @ApiModelProperty(name="warehouseType",value = "仓库对应于不同层级仓库的类型")
    private String warehouseType;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 批次类型 common-正常,defective-残次品,其他类型待定 */
    @ApiModelProperty(name="batchType",value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /** 单据类型,待定 */
    @ApiModelProperty(name="sourceType",value = "单据类型,待定")
    private String sourceType;
    /** 来源单据号 */
    @ApiModelProperty(name="sourceNo",value = "来源单据号")
    private String sourceNo;
    /** 变动前库存 */
    @ApiModelProperty(name="beforeInventory",value = "变动前库存")
    private BigDecimal beforeInventory;
    /** 变动库存 */
    @ApiModelProperty(name="changeInventory",value = "变动库存")
    private BigDecimal changeInventory;
    /** 变动后库存 */
    @ApiModelProperty(name="afterInventory",value = "变动后库存")
    private BigDecimal afterInventory;
    /** 变动类型 */
    @ApiModelProperty(name="changeType",value = "变动类型")
    private BigDecimal changeType;
    /** 出入库标识  in-入库  out-出库 */
    @ApiModelProperty(name="inOutFlag",value = "出入库标识  in-入库  out-出库")
    private String inOutFlag;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 变动时间 */
    @ApiModelProperty(name="changeTime",value = "变动时间")
    private Date changeTime;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getBatchType() {
        return batchType;
    }

    public void setBatchType(String batchType) {
        this.batchType = batchType;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public BigDecimal getBeforeInventory() {
        return beforeInventory;
    }

    public void setBeforeInventory(BigDecimal beforeInventory) {
        this.beforeInventory = beforeInventory;
    }

    public BigDecimal getChangeInventory() {
        return changeInventory;
    }

    public void setChangeInventory(BigDecimal changeInventory) {
        this.changeInventory = changeInventory;
    }

    public BigDecimal getAfterInventory() {
        return afterInventory;
    }

    public void setAfterInventory(BigDecimal afterInventory) {
        this.afterInventory = afterInventory;
    }

    public BigDecimal getChangeType() {
        return changeType;
    }

    public void setChangeType(BigDecimal changeType) {
        this.changeType = changeType;
    }

    public String getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(String inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

}
