package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 物理仓详情响应DTO
 *
 * @author jingran
 * @Description CsPhysicsWarehouseRespDto
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 **/
@ApiModel(value = "csPhysicsWarehouseDetailRespDto", description = "物理仓详情响应DTO")
public class CsPhysicsWarehouseDetailRespDto extends BaseRespDto {
    /**
     * 仓库ID
     **/
    @ApiModelProperty(name = "id", value = "仓库ID")
    private Long id;
    /**
     * 仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓
     ***/
    @ApiModelProperty(name = "warehouseType", value = "仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓")
    private String warehouseType;
    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效 com.dtyunxi.yundt.cube.center.inventory.enums.CsPhysicsWarehouseStatusEnum
     **/
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /**
     * 是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用
     **/
    @ApiModelProperty(name = "rdcFlag", value = "是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用")
    private String rdcFlag;
    /**
     * eas仓库编码
     **/
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;
    /**
     * 国家编码
     **/
    @ApiModelProperty(name = "countryCode", value = "国家编码")
    private String countryCode;
    /**
     * 国家名称
     **/
    @ApiModelProperty(name = "country", value = "国家名称")
    private String country;
    /**
     * 省份编码
     **/
    @ApiModelProperty(name = "provinceCode", value = "省份编码")
    private String provinceCode;
    /**
     * 省份名称
     **/
    @ApiModelProperty(name = "province", value = "省份名称")
    private String province;
    /**
     * 城市编码
     **/
    @ApiModelProperty(name = "cityCode", value = "城市编码")
    private String cityCode;
    /**
     * 城市名称
     **/
    @ApiModelProperty(name = "city", value = "城市名称")
    private String city;
    /**
     * 区县编码
     **/
    @ApiModelProperty(name = "districtCode", value = "区县编码")
    private String districtCode;
    /**
     * 区县名称
     **/
    @ApiModelProperty(name = "district", value = "区县名称")
    private String district;
    /**
     * 详细地址
     **/
    @ApiModelProperty(name = "detailAddress", value = "详细地址")
    private String detailAddress;
    /**
     * 联系人
     **/
    @ApiModelProperty(name = "contacts", value = "联系人")
    private String contacts;
    /**
     * 联系电话
     **/
    @ApiModelProperty(name = "phone", value = "联系电话")
    private String phone;
    /**
     * 邮政编码
     **/
    @ApiModelProperty(name = "postalCode", value = "邮政编码")
    private String postalCode;
    /**
     * 经度
     **/
    @ApiModelProperty(name = "longitude", value = "经度")
    private String longitude;
    /**
     * 纬度
     **/
    @ApiModelProperty(name = "latitude", value = "纬度")
    private String latitude;
    /**
     * 创建人
     ***/
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;
    /**
     * 创建时间
     ***/
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;
    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRdcFlag() {
        return rdcFlag;
    }

    public void setRdcFlag(String rdcFlag) {
        this.rdcFlag = rdcFlag;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getEasWarehouseCode() {
        return easWarehouseCode;
    }

    public void setEasWarehouseCode(String easWarehouseCode) {
        this.easWarehouseCode = easWarehouseCode;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    @Override
    public String getCreatePerson() {
        return createPerson;
    }

    @Override
    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getDetailAddress() {
        return detailAddress;
    }

    public void setDetailAddress(String detailAddress) {
        this.detailAddress = detailAddress;
    }

    public String getContacts() {
        return contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }
}
