/**
 * @(#)CsReceiveNoticeOrderApi.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderAddReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * CsReceiveNoticeOrderApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@Api(tags = {"CsReceiveNoticeOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csReceiveNoticeOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsReceiveNoticeOrderApi {

    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "创建收货通知单", notes = "创建收货通知单")
    RestResponse<Long> add(@Validated @RequestBody CsReceiveNoticeOrderAddReqDto addReqDto);

    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsReceiveNoticeOrderUpdateReqDto updateReqDto);

    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    /**
     * 创建收货通知单流程，包括创建收货通知单、生成入库通知单、通知营销云收货
     *
     * @param addReqDto 单据入参
     * @return 收货通知单id
     */
    @PostMapping(value = "/createReceiveOrderProcess", produces = "application/json")
    @ApiOperation(value = "创建收货通知单流程", notes = "创建收货通知单流程")
    RestResponse<Long> createReceiveOrderProcess(@Validated @RequestBody CsReceiveNoticeOrderAddReqDto addReqDto);

    @GetMapping(value = "/update/orderStatus", produces = "application/json")
    @ApiOperation(value = "修改收货货单单据状态,preOrderNo前置订单号, action(单据动作):auditPass.审核通过，auditAdjust.审核不通过", notes = "修改收货货单单据状态")
    RestResponse<Void> updateOrderStatus(@RequestParam("preOrderNo") String preOrderNo, @RequestParam("action") String action);

    @PostMapping(value = "/reCheckInInventoryOverall", produces = "application/json")
    @ApiOperation(value = "修数-复核入库(用于复核成功但是没有入库的场景)", notes = "修数")
    RestResponse<Void> reCheckInInventoryOverall(CsReceiveResultOrderAddReqDto addReqDto);
}