package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.CargoStorageTotalReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 货品库存总表服务接口
*
* @author songjiang.zxj
* @since 2021-10-21
*/
@Api(tags = {"货品库存总表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICargoStorageTotalApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/inventory/log",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICargoStorageTotalApi {

/**
* 新增货品库存总表
*
* @param addReqDto 货品库存总表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增货品库存总表", notes = "新增货品库存总表")
RestResponse<Long> addCargoStorageTotal(@RequestBody CargoStorageTotalReqDto addReqDto);

    /**
    * 修改货品库存总表
    *
    * @param modifyReqDto 货品库存总表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改货品库存总表", notes = "修改货品库存总表")
    RestResponse<Void> modifyCargoStorageTotal(@RequestBody CargoStorageTotalReqDto modifyReqDto);

    /**
    * 删除货品库存总表
    *
    * @param ids        货品库存总表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除货品库存总表", notes = "删除货品库存总表")
    RestResponse<Void> removeCargoStorageTotal(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
