package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryInitOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author jingran-
 * @version 1.0
 * @Date 2022/1/14 1:47 下午
 */
@Api(tags = {"库存中心-库存操作相关接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInventoryExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInventoryExposedApi {

    /**
     * 库存预占
     * 注意：此接口只会做预占操作，仅仅做库存预占这件事，不会有单据生成或者变动
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptInventory", produces = "application/json")
    @ApiOperation(value = "库存预占", notes = "库存预占")
    RestResponse<Boolean> preemptInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存预占，营销云专用；预占带批次、不带批次的库存表，生成预占记录
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptInventoryByYxy", produces = "application/json")
    @ApiOperation(value = "库存预占,营销云专用", notes = "库存预占，营销云专用")
    RestResponse<Boolean> preemptInventoryByYxy(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存预占，包含单据操作-生成发货通知单
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptOrderInventory", produces = "application/json")
    @ApiOperation(value = "库存预占，包含单据操作-生成发货通知单", notes = "库存预占，包含单据操作-生成发货通知单")
    RestResponse<Boolean> preemptOrderInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存释放
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventory", produces = "application/json")
    @ApiOperation(value = "库存释放", notes = "库存释放")
    RestResponse<Boolean> releaseInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存释放，营销云专用；根据关联单号查询预占记录，释放有效占用预占记录，更新预占记录状态；
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventoryByYxy", produces = "application/json")
    @ApiOperation(value = "库存释放，营销云专用", notes = "库存释放，营销云专用")
    RestResponse<Boolean> releaseInventoryByYxy(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);


    @PostMapping(value = "/reloadPreOccupy", produces = "application/json")
    @ApiOperation(value = "营销云 释放库存并重新预占", notes = "释放库存并重新预占")
    RestResponse<Boolean> reloadPreOccupy(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存释放，包含单据操作-取消发货通知单
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseOrderInventory", produces = "application/json")
    @ApiOperation(value = "库存释放，包含单据操作-取消发货通知单", notes = "库存释放，包含单据操作-取消发货通知单")
    RestResponse<Boolean> releaseOrderInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存释放，根据订单号找到预占记录进行释放
     *
     * @param releasePreemptOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventoryByPreemption", produces = "application/json")
    @ApiOperation(value = "库存释放，根据订单号找到预占记录进行释放", notes = "库存释放，根据订单号找到预占记录进行释放")
    RestResponse<Boolean> releaseInventoryByPreemption(@Validated @RequestBody CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto);

    /**
     * 审批通过库存操作
     * 审批通过，对于TCBJ的业务，业务审批或者财务审批会选择批次
     * 然后审批通过后，会释放之前的库存，然后按照对应的批次进行
     * 库存预占
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/approvePassInventory", produces = "application/json")
    @ApiOperation(value = "审批通过库存操作", notes = "审批通过库存操作")
    RestResponse<Boolean> approvePassInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存发货扣减
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/deductionInventory", produces = "application/json")
    @ApiOperation(value = "库存发货扣减", notes = "库存发货扣减")
    RestResponse<Boolean> deductionInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 入库初始化物理仓库存
     * 入库操作，从底层物理仓库存直接入库，然后物理仓库存
     * 操作完之后，需要往上同步至逻辑仓
     *
     * @param csInventoryInitOperateReqDto
     * @return
     */
    @PostMapping(value = "/initPhysicsInventory", produces = "application/json")
    @ApiOperation(value = "入库初始化物理仓库存", notes = "入库初始化物理仓库存")
    RestResponse<Boolean> initPhysicsInventory(@Validated @RequestBody CsInventoryInitOperateReqDto csInventoryInitOperateReqDto);

    /**
     * 一期迭代二初始化逻辑、物理仓库存
     * 入库操作，从底层物理仓库存直接入库，然后物理仓库存
     * 操作完之后，需要往上同步至逻辑仓
     *
     * @param operateCargoReqDtoList 仓库货品集合
     * @return
     */
    @PostMapping(value = "/initLogicPhysicsInventory", produces = "application/json")
    @ApiOperation(value = "一期迭代二初始化逻辑、物理仓库存", notes = "一期迭代二初始化逻辑、物理仓库存")
    RestResponse<Boolean> initLogicPhysicsInventory(@Validated @RequestBody List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList);

    /**
     * 全量更新总库存即使库存(balance)；
     *
     * @param preOrderNo 前置单据
     * @param type       类型
     * @return 更新数量
     */
    @GetMapping(value = "/update/inventoryTotalBalance", produces = "application/json")
    @ApiOperation(value = "全量更新总库存即使库存,preOrderNo前置订单号,type 类型", notes = "全量更新总库存即使库存")
    RestResponse<Integer> updateInventoryTotalBalance(@RequestParam("preOrderNo") String preOrderNo, @RequestParam("type") String type);

    /**
     * 全量更新总库存预占数量（preempt）；
     *
     * @param preOrderNo 前置单据
     * @param type       类型
     * @return 更新数量
     */
    @GetMapping(value = "/update/inventoryTotalPreempt", produces = "application/json")
    @ApiOperation(value = "全量更新总库存预占数量,preOrderNo前置订单号,type 类型", notes = "全量更新总库存预占数量")
    RestResponse<Integer> updateInventoryTotalPreempt(@RequestParam("preOrderNo") String preOrderNo, @RequestParam("type") String type);

}
