package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.InventoryItemExtendRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 库存商品属性服务接口
 *
 * @author by_liusong
 * @since 2022-11-23
 */
@Api(tags = {"库存商品属性服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IInventoryItemExtendQueryApi",
        name = "yundt-cube-center-inventory",
        path = "/v1/inventoryItemExtend",
        url = "${yundt-cube-center-inventoryapi:}"
)
public interface IInventoryItemExtendQueryApi {

    /**
     * 根据id查询
     *
     * @param id id
     * @return 数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询", notes = "根据id查询")
    RestResponse<InventoryItemExtendRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 商品属性数据
     *
     * @param filter 查询条件
     * @return 分页数据
     */
    @GetMapping("/queryInventoryItemExtend")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=InventoryItemExtendReqDto")
    RestResponse<List<InventoryItemExtendRespDto>> queryInventoryItemExtend(@RequestParam("filter") String filter);

    /**
     * 分页数据
     *
     * @param filter   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=InventoryItemExtendReqDto")
    RestResponse<PageInfo<InventoryItemExtendRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
