package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 单据编码生成的前缀枚举
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 7:20 下午
 */
public enum CsDocumentCodePrefixEnum {

    /** COMMON **/
    COMMON("COMMON","普通"),

    /** 发货通知单 **/
    FHTZ("FHTZ","发货通知单"),

    /** 出库通知单 **/
    CKTZ("CKTZ","出库通知单"),

    /** 出库结果单 **/
    CKJG("CKJG","出库结果单"),

    /** 发货结果单 **/
    FHJG("FHJG","发货结果单"),

    /** 收货通知单 **/
    SHTZ("SHTZ","收货通知单"),

    /** 入库通知单 **/
    RKTZ("RKTZ","入库通知单"),

    /** 入库结果单 **/
    RkJG("RKJG","入库结果单"),

    /** 收货结果单 **/
    SHJG("SHJG","收货结果单"),

    /** 逻辑仓库 **/
    LOGIC_WAREHOUSE("L","逻辑仓库"),

    /** 物理仓库 **/
    PHYSICS_WAREHOUSE("P","物理仓库"),

    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsDocumentCodePrefixEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsDocumentCodePrefixEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsDocumentCodePrefixEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
