/**
 * @(#) AdjustActionEnum.java 1.0 2021/11/1/001
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.constant;

import com.google.common.collect.Sets;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 库存调整单-商品库存-增加或者减少
 *
 * @author zimu
 * @date 2021/11/1/001
 * @since 1.0.0
 */
public enum AdjustActionEnum {

    INCR(1, "增加"),
    DECR(2, "减少"),
    ;


    AdjustActionEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final int code;
    private final String desc;
    public static final Map<Integer, AdjustActionEnum> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));

    public static AdjustActionEnum forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
