/**
 * @(#)CsOutResultOrderAddReqDto.java 1.0 2021/12/29 11:13
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

//

import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @Description CsOutResultOrderAddReqDto
 * @Date: 2021/12/29 11:13
 * @since 1.0.0
 */
@ApiModel(value = "csOutResultOrderAddReqDto", description = "新增Dto")
public class CsOutResultOrderAddReqDto implements Serializable {

    /**
     * 出库结果单号
     */
    @ApiModelProperty(name = "documentNo", value = "出库结果单号")
    private String documentNo;
    /**
     * 关联单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
     * 外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    /**
     * 单据状态,待定
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
     * 发货店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "发货店铺ID")
    private Long shopId;
    /**
     * 发货店铺编码
     */
    @ApiModelProperty(name = "shopCode", value = "发货店铺编码")
    private String shopCode;
    /**
     * 发货店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "发货店铺名称")
    private String shopName;
    /**
     * 发货仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "发货仓库ID")
    private Long warehouseId;
    /**
     * 发货仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "发货仓库编码")
    private String warehouseCode;
    /**
     * 发货仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "发货仓库名称")
    private String warehouseName;
    /**
     * 仓库分类,physics-物理仓,logic-逻辑仓
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /**
     * 出库总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "出库总数量")
    private BigDecimal totalQuantity;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 物流公司编码
     */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码")
    private String shippingCompanyCode;
    /**
     * 物流公司
     */
    @ApiModelProperty(name = "shippingCompany", value = "物流公司")
    private String shippingCompany;
    /**
     * 物流单号
     */
    @ApiModelProperty(name = "shippingCode", value = "物流单号")
    private String shippingCode;

    @ApiModelProperty(name = "contactDto", value = "前置单据的冗余信息")
    private ContactDto contactDto;

    @ApiModelProperty(name = "detailAddReqDtoList", value = "出库结果明细")
    private List<CsOutResultOrderDetailAddReqDto> detailAddReqDtoList;

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getShippingCode() {
        return shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public ContactDto getContactDto() {
        return contactDto;
    }

    public void setContactDto(ContactDto contactDto) {
        this.contactDto = contactDto;
    }

    public List<CsOutResultOrderDetailAddReqDto> getDetailAddReqDtoList() {
        return detailAddReqDtoList;
    }

    public void setDetailAddReqDtoList(List<CsOutResultOrderDetailAddReqDto> detailAddReqDtoList) {
        this.detailAddReqDtoList = detailAddReqDtoList;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }


    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}