/**
 * @(#)CsPhysicsWarehouseQueryApi.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseLogicDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseLogicDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* 物理仓暴露给PCP应用层的相关查询接口
*
* @author jingran
* @Date: 2021/12/29 11:15
* @since 1.0.0
*/
@Api(tags = {"物理仓暴露给PCP应用层的相关查询接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csPhysicsWarehouseExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsPhysicsWarehouseExposedQueryApi {

    /**
     * 根据id查询物理仓详情
     *
     * @param id 物理仓仓库ID
     * @return
     */
    @GetMapping(value = "/{id}/queryDetailById", produces = "application/json")
    @ApiOperation(value = "根据id查询物理仓详情", notes = "根据id查询物理仓详情")
    RestResponse<CsPhysicsWarehouseDetailRespDto> queryDetailById(@PathVariable("id") Long id);

    /**
     * 物理仓详情查询关联逻辑仓信息
     *
     * @param csPhysicsWarehouseLogicDetailReqDto 逻辑仓查询DTO
     * @return
     */
    @GetMapping(value = "/queryLogicInfo", produces = "application/json")
    @ApiOperation(value = "根据id查询物理仓详情", notes = "根据id查询物理仓详情")
    RestResponse<PageInfo<CsPhysicsWarehouseLogicDetailRespDto>> queryLogicInfo(@RequestBody CsPhysicsWarehouseLogicDetailReqDto csPhysicsWarehouseLogicDetailReqDto);

    /**
     * 物理仓分页列表查询
     *
     * @param csPhysicsWarehousePageQueryDto 请求DTO
     * @return
     */
    @GetMapping(value = "/queryPageInfo", produces = "application/json")
    @ApiOperation(value = "物理仓分页列表查询", notes = "物理仓分页列表查询")
    RestResponse<PageInfo<CsPhysicsWarehousePageRespDto>> queryPageInfo(@RequestBody CsPhysicsWarehousePageQueryDto csPhysicsWarehousePageQueryDto);

}