package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 库存更新是否覆盖枚举
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/13 5:38 下午
 */
public enum CsInventoryCoverInventoryFlagEnum {

    /**
     * 覆盖
     **/
    COVER("cover", "覆盖"),
    /**
     * 更新
     **/
    UPDATE("update", "更新"),
    ;

    private String code;

    private String desc;

    CsInventoryCoverInventoryFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsInventoryCoverInventoryFlagEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsInventoryCoverInventoryFlagEnum.values()).stream().filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }
}
