package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics;

import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 库存基础出入库，货品明细信息DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 2:25 下午
 */
public class CsInventoryInOutBasicsCargoDto implements Serializable {

    @ApiModelProperty(name="id",value = "主键")
    private Long id;

    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;

    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;

    /** 仓库对应于不同层级仓库的类型 */
    @ApiModelProperty(name="warehouseType",value = "仓库对应于不同层级仓库的类型")
    private String warehouseType;

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;

    /** 货品批次 */
    @ApiModelProperty(name="batch",value = "货品批次")
    private String batch;

    /** 货品批次类型 */
    @ApiModelProperty(name="batchType",value = "货品批次类型")
    private String batchType;

    /** 是否为活动商品 0-普通商品(默认)  1-活动商品 */
    @ApiModelProperty(name="activityFlag",value = "是否为活动商品 0-普通商品  1-活动商品，如果是活动商品，则此标识必传，且为1")
    private Integer activityFlag;

    /** 活动ID */
    @ApiModelProperty(name="activityId",value = "活动ID，如果是活动商品，则活动ID必传")
    private Long activityId;

    /** 是否为虚拟商品 0-正常商品(默认)  1-虚拟商品 */
    @ApiModelProperty(name="cargoVirtualFlag",value = "是否为活动商品 0-普通商品  1-活动商品")
    private Integer cargoVirtualFlag;

    /** 总库存 */
    @ApiModelProperty(name="balance",value = "总库存")
    private BigDecimal balance;

    /** 预占库存 */
    @ApiModelProperty(name="preempt",value = "预占库存")
    private BigDecimal preempt;

    /** 已分配库存 */
    @ApiModelProperty(name="allocate",value = "已分配库存")
    private BigDecimal allocate;

    /** 活动分配库存 */
    @ApiModelProperty(name="activityAllocate",value = "活动分配库存")
    private BigDecimal activityAllocate;

    /** 在途库存 */
    @ApiModelProperty(name="intransit",value = "在途库存")
    private BigDecimal intransit;

    /** 已调拨库存 */
    @ApiModelProperty(name="transfer",value = "已调拨库存")
    private BigDecimal transfer;

    /** 已完成库存 */
    @ApiModelProperty(name="completed",value = "已完成库存")
    private BigDecimal completed;

    /** 可用库存 */
    @ApiModelProperty(name="available",value = "可用库存")
    private BigDecimal available;


    /**以下字段，传值不需要关注的字段**/
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;

    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;

    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;

    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;

    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;

    /** 活动名称 */
    @ApiModelProperty(name="activityName",value = "活动名称")
    private String activityName;

    /** 活动编码 */
    @ApiModelProperty(name="activityCode",value = "活动编码")
    private String activityCode;

    /** 活动类型 */
    @ApiModelProperty(name="activityType",value = "活动类型")
    private String activityType;

    /** 活动套装数 */
    @ApiModelProperty(name="activityNum",value = "活动套装数")
    private Integer activityNum;

    /** 套装编码 */
    @ApiModelProperty(name="suitCode",value = "套装编码")
    private String suitCode;

    /** 套转编码名称 */
    @ApiModelProperty(name="suitName",value = "套转编码名称")
    private String suitName;

    /** 店铺ID */
    @ApiModelProperty(name="shopId",value = "店铺ID")
    private Long shopId;

    /** 店铺名称 */
    @ApiModelProperty(name="shopName",value = "店铺名称")
    private String shopName;

    /** 店铺编码 */
    @ApiModelProperty(name="shopCode",value = "shopCode")
    private String shopCode;

    /** 比例,此活动在此活动里占的比例,此货品活动总库存 = 活动套数 x 此货品比例 */
    @ApiModelProperty(name="cargoProportion",value = "比例,此活动在此活动里占的比例,此货品活动总库存 = 活动套数 x 此货品比例")
    private BigDecimal cargoProportion;

    /** 活动是否已结束  ongoing-进行中  terminate-已结束 */
    @ApiModelProperty(name="finishFlag",value = "'活动是否已结束  ongoing-进行中  terminate-已结束")
    private String finishFlag;

    /** 生产日期 */
    @ApiModelProperty(name = "expireTime", value = "生产日期")
    private Date expireTime;
    /** 过期日期 */
    @ApiModelProperty(name = "produceTime", value = "过期日期")
    private Date produceTime;

    /** 排序ID **/
    @ApiModelProperty(name = "sortId", value = "排序ID")
    private Long sortId;

    /**
     * 是否礼盒产品
     */
    @ApiModelProperty(name = "isGift", value = "是否礼盒；0：否；1：是")
    private Integer isGift;

    public CsInventoryInOutBasicsCargoDto() {

    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getBatchType() {
        return batchType;
    }

    public void setBatchType(String batchType) {
        this.batchType = batchType;
    }

    public Integer getActivityFlag() {
        return activityFlag;
    }

    public void setActivityFlag(Integer activityFlag) {
        this.activityFlag = activityFlag;
    }

    public Integer getCargoVirtualFlag() {
        return cargoVirtualFlag;
    }

    public void setCargoVirtualFlag(Integer cargoVirtualFlag) {
        this.cargoVirtualFlag = cargoVirtualFlag;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getAllocate() {
        return allocate;
    }

    public void setAllocate(BigDecimal allocate) {
        this.allocate = allocate;
    }

    public BigDecimal getActivityAllocate() {
        return activityAllocate;
    }

    public void setActivityAllocate(BigDecimal activityAllocate) {
        this.activityAllocate = activityAllocate;
    }

    public BigDecimal getIntransit() {
        return intransit;
    }

    public void setIntransit(BigDecimal intransit) {
        this.intransit = intransit;
    }

    public BigDecimal getTransfer() {
        return transfer;
    }

    public void setTransfer(BigDecimal transfer) {
        this.transfer = transfer;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public BigDecimal getCompleted() {
        return completed;
    }

    public void setCompleted(BigDecimal completed) {
        this.completed = completed;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public Integer getActivityNum() {
        return activityNum;
    }

    public void setActivityNum(Integer activityNum) {
        this.activityNum = activityNum;
    }

    public String getSuitCode() {
        return suitCode;
    }

    public void setSuitCode(String suitCode) {
        this.suitCode = suitCode;
    }

    public String getSuitName() {
        return suitName;
    }

    public void setSuitName(String suitName) {
        this.suitName = suitName;
    }

    public String getActivityName() {
        return activityName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public BigDecimal getCargoProportion() {
        return cargoProportion;
    }

    public void setCargoProportion(BigDecimal cargoProportion) {
        this.cargoProportion = cargoProportion;
    }

    public String getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(String finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Long getSortId() {
        return sortId;
    }

    public void setSortId(Long sortId) {
        this.sortId = sortId;
    }

    public Integer getIsGift() {
        return isGift;
    }

    public void setIsGift(Integer isGift) {
        this.isGift = isGift;
    }
}
