package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.OptionLogReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 接口操作表服务接口
*
* @author songjiang.zxj
* @since 2021-10-21
*/
@Api(tags = {"接口操作表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IOptionLogApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/inventory/log",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IOptionLogApi {

/**
* 新增接口操作表
*
* @param addReqDto 接口操作表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增接口操作表", notes = "新增接口操作表")
RestResponse<Long> addOptionLog(@RequestBody OptionLogReqDto addReqDto);

    /**
    * 修改接口操作表
    *
    * @param modifyReqDto 接口操作表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改接口操作表", notes = "修改接口操作表")
    RestResponse<Void> modifyOptionLog(@RequestBody OptionLogReqDto modifyReqDto);

    /**
    * 删除接口操作表
    *
    * @param ids        接口操作表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除接口操作表", notes = "删除接口操作表")
    RestResponse<Void> removeOptionLog(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
