package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 库存操作请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/18 2:21 下午
 */
@ApiModel(value = "csInventoryPreemptReqDto", description = "库存操作请求DTO")
public class CsInventoryOperateReqDto implements Serializable {
    /**
     * 来源单据号
     */
    @ApiModelProperty(name = "sourceNo", value = "来源单据号")
    private String sourceNo;

    /**
     * 来源单据类型 com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum
     */
    @ApiModelProperty(name = "sourceType", value = "来源单据类型")
    private String sourceType;

    /**
     * 是否校验负库存  0-不校验，允许负库存     1-校验(默认)，不允许负库存
     */
    @ApiModelProperty(name = "negativeValidate", value = "是否校验负库存  0-不校验，允许负库存     1-校验(默认)，不允许负库存")
    private Integer negativeValidate = YesNoEnum.YES.getValue();

    /**
     * 货品明细
     */
    @ApiModelProperty(name = "operateCargoReqDtoList", value = "货品明细")
    private List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList;

    /**
     * 出入库标识  in-入库  out-出库   com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum
     * 对于库存中心底层操作需要用到，库存中心暴露给其他中心的接口或者应用层的接口，代码逻辑里会做处理，可以不传，
     * 但是如果是直接操作库存中心底层的，需要传入
     */
    @ApiModelProperty(name = "inOutFlag", value = "出入库标识  in-入库  out-出库")
    private String inOutFlag;

    /**
     * 操作批次表的时候，是否同步更新总表  0-不更新（默认）  1-更新
     **/
    @ApiModelProperty(name = "updateTotalFlag", value = "操作批次表的时候，是否同步更新总表  0-不更新（默认）  1-更新")
    private Integer updateTotalFlag = YesNoEnum.NO.getValue();

    @ApiModelProperty(name = "suffix", value = "操作后缀")
    private String suffix;

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Integer getUpdateTotalFlag() {
        return updateTotalFlag;
    }

    public void setUpdateTotalFlag(Integer updateTotalFlag) {
        this.updateTotalFlag = updateTotalFlag;
    }

    public CsInventoryOperateReqDto() {
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Integer getNegativeValidate() {
        return negativeValidate;
    }

    public void setNegativeValidate(Integer negativeValidate) {
        this.negativeValidate = negativeValidate;
    }

    public List<CsInventoryOperateCargoReqDto> getOperateCargoReqDtoList() {
        return operateCargoReqDtoList;
    }

    public void setOperateCargoReqDtoList(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList) {
        this.operateCargoReqDtoList = operateCargoReqDtoList;
    }

    public String getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(String inOutFlag) {
        this.inOutFlag = inOutFlag;
    }
}
