package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 供货模式配置表服务接口
*
* @author Ghosn
* @since 2024-11-05
*/
@Api(tags = {"供货模式配置表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-IWarehouseSupplyConfigQueryApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/warehouse/supply/config",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IWarehouseSupplyConfigQueryApi {

    /**
    * 根据id查询供货模式配置表
    *
    * @param id 供货模式配置表id
    * @return   供货模式配置表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询供货模式配置表", notes = "根据id查询供货模式配置表")
    RestResponse<WarehouseSupplyConfigRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 供货模式配置表分页数据
    *
    * @param filter   供货模式配置表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 供货模式配置表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "供货模式配置表分页数据", notes = "根据filter查询条件查询供货模式配置表数据，filter=WarehouseSupplyConfigReqDto")
    RestResponse<PageInfo<WarehouseSupplyConfigRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
