package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 根据发货通知单回滚库存
 * @author ghosn
 * @create 2022/12/6 15:26
 */
@ApiModel(value = "RollbackDeliveryOrderReqDto", description = "请求信息Dto")
@Data
public class RollbackDeliveryOrderReqDto {

    /**
     * 发货结果单单号
     */
    @ApiModelProperty(name = "documentNo", value = "发货结果单单号")
    private String documentNo;

    /**
     * 关联单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;

    /**
     * 前置单号 -> 触发入库的单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;

    /**
     * 库存详细
     */
    @ApiModelProperty(name = "tcbjProOccupyItemReqDtos", value = "库存详细")
    private List<TcbjProOccupyItemReqDto> tcbjProOccupyItemReqDtos;
}
