/**
 * @(#)CsLogicWarehouseRespDto.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

//

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;

/**
 * @author jingran
 * @Description CsLogicWarehouseRespDto
 * @Date: 2021/12/29 11:12
 * @since 1.0.0
 */
@ApiModel(value = "csLogicWarehouseRespDto", description = "返回信息Dto")
public class CsLogicWarehouseRespDto extends BaseRespDto {

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库类型,待定
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型,待定")
    private String warehouseType;
    /**
     * 仓库状态 initial-初始,enable-启用,disable-停用
     */
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-启用,disable-停用")
    private String warehouseStatus;

    /**
     * 是否主仓：1.是，0否
     */
    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：1.是，0否")
    private Integer mainWarehouse;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "isDefault", value = "是否默认:0.否,1.是")
    private Integer isDefault = 1;

    /**
     * spa工厂
     */
    @ApiModelProperty(name = "sapFactory", value = "spa工厂")
    private String sapFactory;

    /**
     * sap库位
     */
    @ApiModelProperty(name = "sapStorageLocation", value = "sap库位")
    private String sapStorageLocation;

    /**
     * 是否允许负库存 0-不允许 1-允许
     */
    @ApiModelProperty(name = "negative_flag", value = "是否允许负库存 0-不允许 1-允许")
    private Integer negativeFlag;

    /**
     * 是否允许负库存 0-不允许 1-允许
     */
    @ApiModelProperty(name = "warehouseIsNegative", value = "是否允许负库存 0-不允许 1-允许")
    private Integer warehouseIsNegative;

    /**
     * 渠道类型
     */
    @ApiModelProperty(name = "channel_type", value = "渠道类型")
    private String channelType;

    @ApiModelProperty(name = "warehouseAddress", value = "地址信息")
    private CsWarehouseAddressRespDto warehouseAddress;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contact", value = "联系人")
    private String contact;
    /**
     * 联系电话
     */
    @ApiModelProperty(name = "phone", value = "联系电话")
    private String phone;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    public CsWarehouseAddressRespDto getWarehouseAddress() {
        return warehouseAddress;
    }

    public void setWarehouseAddress(CsWarehouseAddressRespDto warehouseAddress) {
        this.warehouseAddress = warehouseAddress;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        String descByCode = CsWarehouseTypeEnum.getDescByCode(warehouseType);
        return StringUtils.isNotBlank(descByCode) ? descByCode : warehouseType;
    }

    public String getWarehouseTypeCode() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public String getSapFactory() {
        return sapFactory;
    }

    public void setSapFactory(String sapFactory) {
        this.sapFactory = sapFactory;
    }

    public String getSapStorageLocation() {
        return sapStorageLocation;
    }

    public void setSapStorageLocation(String sapStorageLocation) {
        this.sapStorageLocation = sapStorageLocation;
    }

    public Integer getNegativeFlag() {
        return negativeFlag;
    }

    public void setNegativeFlag(Integer negativeFlag) {
        this.negativeFlag = negativeFlag;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Integer getWarehouseIsNegative() {
        return warehouseIsNegative;
    }

    public void setWarehouseIsNegative(Integer warehouseIsNegative) {
        this.warehouseIsNegative = warehouseIsNegative;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Integer getMainWarehouse() {
        return mainWarehouse;
    }

    public void setMainWarehouse(Integer mainWarehouse) {
        this.mainWarehouse = mainWarehouse;
    }
}
