package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
* 供货模式配置表Eo对象
*
* @author Ghosn
* @since 2024-11-05
*/
@Data
@NoArgsConstructor
@ApiModel(value = "WarehouseSupplyConfigReqDto", description = "供货模式配置表Eo对象")
public class WarehouseSupplyConfigReqDto extends RequestDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "shopId", value = "店铺ID 经销商店铺id")
    private Long shopId;
    /**
     *  组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID 经销商orgId")
    private Long organizationId;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
    *  所属组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;
    /**
    *  是否开启分仓发货；1：默认发货；2：分仓发货；3：混合发货
    */
    @ApiModelProperty(name = "supplyType", value = "是否开启分仓发货；1：默认发货；2：分仓发货；3：混合发货")
    private Integer supplyType;
    /**
    *  客户ID
    */
    @ApiModelProperty(name = "customerId", value = "客户ID 小b客户")
    private Long customerId;
    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "warehouseType", value = "仓库类型 0产品仓 1退货仓")
    private String warehouseType;

    public WarehouseSupplyConfigReqDto(Long shopId, Long organizationId, String organizationCode, String organizationName, Integer supplyType, Long customerId, String customerCode) {
        this.shopId = shopId;
        this.organizationId = organizationId;
        this.organizationCode = organizationCode;
        this.organizationName = organizationName;
        this.supplyType = supplyType;
        this.customerId = customerId;
        this.customerCode = customerCode;
    }
}
