package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 库存分页查询DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/14 1:50 下午
 */
@ApiModel(value = "csInventoryQueryReqDto", description = "库存分页查询DTO")
public class CsInventoryPageQueryReqDto extends BasePageDto implements Serializable {

    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;

    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;

    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;

    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;

    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;

    /** 仓库分类  物理仓-physics  逻辑仓-logic  虚拟仓-virtual  渠道仓-channel  */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类")
    private String warehouseClassify;

    @ApiModelProperty(name="currentUserWarehouseIds",value = "当前用户对应仓库id")
    private List<Long> currentUserWarehouseIds;

    public CsInventoryPageQueryReqDto() {
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public List<Long> getCurrentUserWarehouseIds() {
        return currentUserWarehouseIds;
    }

    public void setCurrentUserWarehouseIds(List<Long> currentUserWarehouseIds) {
        this.currentUserWarehouseIds = currentUserWarehouseIds;
    }
}
