package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 库存流水分页查询需要用到的枚举，为了兼容一期的内容，后面可能会直接废弃掉
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/16 11:56 下午
 */
public enum CsInventoryLogPageTypeEnum {

    /**
     * 即时库存
     **/
    BALANCE("balance", "即时库存"),
    /**
     * 锁定库存
     **/
    PREEMPT("preempt", "锁定库存"),

    /**
     * 可用库存
     **/
    AVAILABLE("available", "可用库存"),
    ;

    private String code;

    private String desc;

    CsInventoryLogPageTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsInventoryLogPageTypeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsInventoryLogPageTypeEnum.values()).stream().filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }
}
