package com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.BaseOrderRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author shuidi
 * @Description TyWarehouseRespDto
 * @Date: 2020/01/03 17:20
 * @since 1.0.0
 */
@ApiModel(value = "TcbjDeliveryRespDto", description = "返回信息Dto")
@Data
public class TcbjDeliveryNotiRespDto extends BaseOrderRespDto {
    /**
     * 业务类型 查询
     */
    @ApiModelProperty(name = "type", value = "业务类型")
    private String type;

    private String strType;

    public String getStrType() {
        switch (type) {
            case "101":
                return "销售出库";
            case "102":
                return "分销出库";
            case "103":
                return "退换货出库";
            case "104":
                return "一级退货出库";
            case "105":
                return "调拨出库";
            case "106":
                return "其他出库";

            case "201":
                return "采购入库";
            case "202":
                return "分销入库";
            case "203":
                return "退换货入库";
            case "204":
                return "下级退货入库";
            case "205":
                return "调拨入库";
            case "206":
                return "其他入库";
            case "207":
                return "物料入库";
            default:
                return "--";
        }
    }

    /**
     * 商品数量
     */
    @ApiModelProperty(name = "num", value = "商品数量")
    private String num;
    /**
     * 前置业务单据
     */
    @ApiModelProperty(name = "preNo", value = "前置业务单据")
    private String preNo;
}
