package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.InventoryItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.InventoryItemExtendRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 服务接口
*
* @author by_liusong
* @since 2022-11-23
*/
@Api(tags = {"服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IInventoryItemExtendApi",
    name = "yundt-cube-center-inventory",
    path = "/v1/inventoryItemExtend",
    url = "${yundt-cube-center-inventoryapi:}"
)
public interface IInventoryItemExtendApi {

    /**
    * 新增
    *
    * @param addReqDto 请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增", notes = "新增")
    RestResponse<Long> addInventoryItemExtend(@RequestBody InventoryItemExtendReqDto addReqDto);

    /**
    * 修改
    *
    * @param modifyReqDto 请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> modifyInventoryItemExtend(@RequestBody InventoryItemExtendReqDto modifyReqDto);

    /**
     * 修改或删除
     *
     * @param modifyReqDto 请求对象
     * @return 处理结果
     */
    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> saveOrUpdateInventoryItemExtend(@RequestBody InventoryItemExtendReqDto modifyReqDto);

    /**
    * 删除
    *
    * @param ids        删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> removeInventoryItemExtend(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
