/**
 * @(#)CsInventoryAdjustQueryApi.java 1.0 2022/01/15 15:59
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInventoryAdjustQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInventoryAdjustRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsInventoryAdjustQueryApi
 *
 * @author jingran
 * @Date: 2022/01/15 15:59
 * @since 1.0.0
 */
@Api(tags = {"CsInventoryAdjust接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInventoryAdjust", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInventoryAdjustQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息 - 【单元测试】", notes = "根据id查询信息 - 【单元测试】")
    RestResponse<CsInventoryAdjustRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询 - 【单元测试】", notes = "分页查询 - 【单元测试】")
    RestResponse<PageInfo<CsInventoryAdjustRespDto>> queryByPage(@Validated @RequestBody CsInventoryAdjustQueryDto queryDto);

    /**
     * 参数查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询 - 【单元测试】", notes = "参数查询 - 【单元测试】")
    RestResponse<List<CsInventoryAdjustRespDto>> queryByParam(@Validated @RequestBody CsInventoryAdjustQueryDto queryDto);

}