package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 组合套装商品库存预占请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/11/30 1:47 下午
 */
public class TcbjCombinationActReqDto implements Serializable {

    /**
     * 活动ID
     */
    @ApiModelProperty(name = "activityId", value = "活动ID",required = true)
    private Long activityId;

    /**
     * 活动名称
     */
    @ApiModelProperty(name = "activityName", value = "活动名称",required = true)
    private String activityName;

    /**
     * 活动编码
     */
    @ApiModelProperty(name = "activityCode", value = "活动编码",required = true)
    private String activityCode;

    /**
     * 活动类型
     */
    @ApiModelProperty(name = "activityType", value = "活动类型",required = true)
    private String activityType;

    /**
     * 活动套装数量
     */
    @ApiModelProperty(name = "suiteNum", value = "活动套装数量",required = true)
    private Integer suiteNum;

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID",required = true)
    private Long shopId;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID",required = true)
    private Long warehouseId;

    /**
     * 货品明细数据
     */
    @ApiModelProperty(name = "detailReqDtoList", value = "货品明细数据",required = true)
    List<TcbjCombinationActDetailReqDto> detailReqDtoList;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码",required = false)
    private String warehouseCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称",required = false)
    private String warehouseName;

    /**
     * 套装编码
     */
    @ApiModelProperty(name = "suitCode", value = "套装编码", required = true)
    private String suitCode;

    /**
     * 套装名称
     */
    @ApiModelProperty(name = "suitName", value = "套装名称", required = true)
    private String suitName;

    public TcbjCombinationActReqDto() {
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public Integer getSuiteNum() {
        return suiteNum;
    }

    public void setSuiteNum(Integer suiteNum) {
        this.suiteNum = suiteNum;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public List<TcbjCombinationActDetailReqDto> getDetailReqDtoList() {
        return detailReqDtoList;
    }

    public void setDetailReqDtoList(List<TcbjCombinationActDetailReqDto> detailReqDtoList) {
        this.detailReqDtoList = detailReqDtoList;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getSuitCode() {
        return suitCode;
    }

    public void setSuitCode(String suitCode) {
        this.suitCode = suitCode;
    }

    public String getSuitName() {
        return suitName;
    }

    public void setSuitName(String suitName) {
        this.suitName = suitName;
    }
}
