/**
 * @(#)CsPhysicsInventoryTotalRespDto.java 1.0 2022/01/12 10:16
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @Description CsPhysicsInventoryTotalRespDto
*
* @author jingran
* @Date: 2022/01/12 10:16
* @since 1.0.0
*/
@ApiModel(value = "csPhysicsInventoryTotalRespDto", description = "返回信息Dto")
public class CsPhysicsInventoryTotalRespDto extends BaseRespDto {

    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 总库存 */
    @ApiModelProperty(name="balance",value = "总库存")
    private BigDecimal balance;
    /** 预占库存 */
    @ApiModelProperty(name="preempt",value = "预占库存")
    private BigDecimal preempt;
    /** 已分配库存 */
    @ApiModelProperty(name="allocate",value = "已分配库存")
    private BigDecimal allocate;
    /** 活动分配库存 */
    @ApiModelProperty(name="activityAllocate",value = "活动分配库存")
    private BigDecimal activityAllocate;
    /** 在途库存 */
    @ApiModelProperty(name="intransit",value = "在途库存")
    private BigDecimal intransit;
    /** 已调拨库存 */
    @ApiModelProperty(name="transfer",value = "已调拨库存")
    private BigDecimal transfer;
    /** 已完成库存 */
    @ApiModelProperty(name="completed",value = "已完成库存")
    private BigDecimal completed;
    /** 可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存 */
    @ApiModelProperty(name="available",value = "可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getAllocate() {
        return allocate;
    }

    public void setAllocate(BigDecimal allocate) {
        this.allocate = allocate;
    }

    public BigDecimal getActivityAllocate() {
        return activityAllocate;
    }

    public void setActivityAllocate(BigDecimal activityAllocate) {
        this.activityAllocate = activityAllocate;
    }

    public BigDecimal getIntransit() {
        return intransit;
    }

    public void setIntransit(BigDecimal intransit) {
        this.intransit = intransit;
    }

    public BigDecimal getTransfer() {
        return transfer;
    }

    public void setTransfer(BigDecimal transfer) {
        this.transfer = transfer;
    }

    public BigDecimal getCompleted() {
        return completed;
    }

    public void setCompleted(BigDecimal completed) {
        this.completed = completed;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}
