/**
 * @(#)CsActivityInventoryQueryApi.java 1.0 2022/01/17 10:06
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsActivityInventoryRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
* CsActivityInventoryQueryApi
*
* @author jingran
* @Date: 2022/01/17 10:06
* @since 1.0.0
*/
@Api(tags = {"CsActivityInventory接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csActivityInventory", url = "${yundt.cube.center.inventory.api:}")
public interface ICsActivityInventoryQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsActivityInventoryRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

}