/**
 * @(#)CsPhysicsWarehouseUpdateReqDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
* @Description CsPhysicsWarehouseUpdateReqDto
*
* @author jingran
* @Date: 2021/12/29 11:15
* @since 1.0.0
*/
@ApiModel(value = "csPhysicsWarehouseUpdateReqDto", description = "修改Dto")
public class CsPhysicsWarehouseUpdateReqDto implements Serializable {

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓 */
    @ApiModelProperty(name="warehouseType",value = "仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓")
    private String warehouseType;
    /** 仓库状态 initial-初始,enable-有效,disable-无效 */
    @ApiModelProperty(name="warehouseStatus",value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /**
     * 是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用
     */
    @ApiModelProperty(name = "rdcFlag", value = "是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用")
    private String rdcFlag;
    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     * 是否主仓：0否1是
     */
    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：0否1是")
    private Integer mainWarehouse;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getMainWarehouse() {
        return mainWarehouse;
    }

    public void setMainWarehouse(Integer mainWarehouse) {
        this.mainWarehouse = mainWarehouse;
    }

    public String getRdcFlag() {
        return rdcFlag;
    }

    public void setRdcFlag(String rdcFlag) {
        this.rdcFlag = rdcFlag;
    }
}