/**
 * @(#)CsInventoryYxyDailyAddReqDto.java 1.0 2022/04/13 14:02
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wenyi
 * @Description CsInventoryYxyDailyAddReqDto
 * @Date: 2022/04/13 14:02
 * @since 1.0.0
 */
@Data
@ApiModel(value = "CsInventoryYxyDailyAddReqDto", description = "新增Dto")
public class CsInventoryYxyDailyAddReqDto implements Serializable {
    /**
     * 营销云租户编码
     */
    @ApiModelProperty(name = "orgCode", value = "营销云租户编码")
    private String orgCode;

    /**
     * 仓库编号
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编号")
    private String warehouseCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    /**
     * 批次号
     */
    @ApiModelProperty(name = "batch", value = "批次号")
    private String batch;

    /**
     * 营销云库存总数
     */
    @ApiModelProperty(name = "quantity", value = "营销云库存总数")
    private BigDecimal quantity;

    /**
     * 失效日期
     */
    private String expireTime;

    /**
     * 生效日期
     */
    private String produceTime;

}