package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author shuidi
 */
@ApiModel(value = "tcbjInventoryRespDto", description = "返回信息Dto")
@Data
public class TcbjInventoryRespDto {
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;
    /**
     * 商品货号
     */
    @ApiModelProperty(name = "artNo", value = "商品货号")
    private String artNo;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")//new
    private String batch;
    /**
     * 生产日期
     */
    @ApiModelProperty(name = "produceTime", value = "生产日期")//new
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String produceTime;
    /**
     * 过期日期
     */
    @ApiModelProperty(name = "expireTime", value = "过期日期")//new
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String expireTime;
    /**
     * 即时库存
     */
    @ApiModelProperty(name = "balance", value = "即时库存")
    private Double balance;
    /**
     * 可用库存
     */
    @ApiModelProperty(name = "available", value = "可用库存")
    private Double available;
    /**
     * 锁定库存
     */
    @ApiModelProperty(name = "preempt", value = "锁定库存")
    private Double preempt;
    /**
     * 更新时间
     */
    @ApiModelProperty(name = "updateTime", value = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String updateTime;
}
