package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>单据物流信息 </p>
 *
 * @author jinger
 * @since 1.0
 */
@ApiModel(value = "CsDocumentExpressReqDto", description = "单据物流信息")
public class CsDocumentExpressReqDto implements Serializable {

    @NotNull(message = "单据号不能为空")
    @ApiModelProperty(name = "documentNo", value = "发货结果单号")
    private String documentNo;
    /**
     * 物流公司
     */
    @NotNull(message = "物流公司不能为空")
    @ApiModelProperty(name = "shippingCompany", value = "物流公司")
    private String shippingCompany;
    /**
     * 物流公司编码
     */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码")
    private String shippingCompanyCode;
    /**
     * 物流单号
     */
    @NotNull(message = "物流单号不能为空")
    @ApiModelProperty(name = "shippingCode", value = "物流单号")
    private String shippingCode;

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCode() {
        return shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }
}
