/**
 * @(#)CsWarehouseAddressQueryApi.java 1.0 2022/01/10 11:31
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* CsWarehouseAddressQueryApi
*
* @author jingran
* @Date: 2022/01/10 11:31
* @since 1.0.0
*/
@Api(tags = {"CsWarehouseAddress接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csWarehouseAddress", url = "${yundt.cube.center.inventory.api:}")
public interface ICsWarehouseAddressQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsWarehouseAddressRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

}