/**
 * @(#)CsDeliveryNoticeOrderApi.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * CsDeliveryNoticeOrderApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:08
 * @since 1.0.0
 */
@Api(tags = {"CsDeliveryNoticeOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csDeliveryNoticeOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsDeliveryNoticeOrderApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "创建发货单", notes = "创建发货单")
    RestResponse<Long> add(@Validated @RequestBody CsDeliveryNoticeOrderAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsDeliveryNoticeOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    @GetMapping(value = "/update/orderStatus", produces = "application/json")
    @ApiOperation(value = "(订单驱动)修改发货单单据状态,preOrderNo前置订单号, action(单据动作):successPay.支付成功，auditPass.审核通过，auditAdjust.审核不通过", notes = "修改发货单单据状态")
    RestResponse<Void> updateOrderStatus(@RequestParam("preOrderNo") String preOrderNo, @RequestParam("action") String action);

    @GetMapping(value = "/only/update/documentStatus", produces = "application/json")
    @ApiOperation(value = "根据前置单号，更新发货通知单状态（只更新状态 该接口不做校验和流转）", notes = "修改发货单单据状态")
    RestResponse<Void> onlyUpdateDocumentStatus(@RequestParam("preOrderNo") String preOrderNo, @RequestParam("orderStatus") String orderStatus);

    @PostMapping(value = "/test/add", produces = "application/json")
    @ApiOperation(value = "创建发货单（test）入口", notes = "创建发货单（test）入口")
    RestResponse<Void> CreateDeliverInformOrderProcess2(@Validated @RequestBody MessageVo messageVo);

    @GetMapping(value = "/update/batch", produces = "application/json")
    @ApiOperation(value = "根据前置单据号（订单号）更新货品批次", notes = "根据前置单据号（订单号）更新货品批次")
    RestResponse<String> updateDetailBatchByPreOrderNo(@RequestParam("preOrderNo") String preOrderNo);

    @PostMapping(value = "/updateDetailBatch", produces = "application/json")
    @ApiOperation(value = "根据库存变动结果，更新单据详情的批次号", notes = "根据库存变动结果，更新单据详情的批次号")
    RestResponse<Integer> updateDetailBatch(@Validated @RequestBody CsInventoryOperateReqDto csInventoryOperateReqDto);

    /**
     * 根据订单号创建发货通知单
     *
     * @param orderNo 订单号
     * @return
     */
    @GetMapping(value = "/preemptInventory/createDeliveryByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据订单号创建发货通知单", notes = "根据订单号创建发货通知单")
    RestResponse<Boolean> createDeliveryByOrderNo(@RequestParam("orderNo") String orderNo);

    /**
     * 批量更新发货通知单状态(通过)
     * 校验单据信息 必须全部带批次，更新发货通知单状态，生成出库通知单
     *
     * @param preOrderNoList 前置单号（订单号）集合
     * @return 是否批量更新成功
     */
    @PostMapping(value = "/batchUpdateNoticeStatusPass", produces = "application/json")
    @ApiOperation(value = "批量更新发货通知单状态(通过)", notes = "批量更新发货通知单状态(通过)")
    RestResponse<Boolean> batchUpdateNoticeStatusPass(@RequestBody List<String> preOrderNoList);

    /**
     * 批量更新发货通知单状态(不通过)
     * 校验单据信息 必须为待审核，更新发货通知单状态，释放预占库存
     *
     * @param preOrderNoList 前置单号（订单号）集合
     * @return 是否批量更新成功
     */
    @PostMapping(value = "/batchUpdateNoticeStatusNoPass", produces = "application/json")
    @ApiOperation(value = "批量更新发货通知单状态(不通过)", notes = "批量更新发货通知单状态(不通过)")
    RestResponse<Boolean> batchUpdateNoticeStatusNoPass(@RequestBody List<String> preOrderNoList);


}