package com.dtyunxi.yundt.cube.center.inventory.constant;

/**
 * 库存策略
 *
 * @author lius5
 */
public enum ItemInventoryStrategyEnum {

    DEFAULT(1, "default_strategy", "默认策略"),
    SEPARATE(2, "separate_strategy", "分仓发货策略"),
    UNITE(3, "unite_strategy", "多仓联合发货策略"),

    ;

    private Integer typeCode;
    private String code;
    private String name;

    ItemInventoryStrategyEnum(Integer typeCode, String code, String name) {
        this.typeCode = typeCode;
        this.code = code;
        this.name = name;
    }

    public Integer getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(Integer typeCode) {
        this.typeCode = typeCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ItemInventoryStrategyEnum getByCode(Integer typeCode) {
        for (ItemInventoryStrategyEnum itemInventoryStrategyEnum : ItemInventoryStrategyEnum.values()) {
            if (itemInventoryStrategyEnum.getTypeCode().equals(typeCode)) {
                return itemInventoryStrategyEnum;
            }
        }
        return null;
    }
}
