package com.dtyunxi.yundt.cube.center.inventory.dto.base.req;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class TcbjResGenReqDto {
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    @ApiModelProperty(name = "type", value = "业务类型")
    private Integer type;
    @ApiModelProperty(name = "preNo", value = "前置业务单据")
    private String preNo;
    @ApiModelProperty(name = "notiNo", value = "通知单据")
    private String notiNo;

    @JSONField(name = "resGenItemReqDtos")
    private List<TcbjResGenItemReqDto> resGenItemReqDtos;
    @ApiModelProperty(name = "isNewCheck", value = "是否是新的复核操作")
    private Boolean isNewCheck = false;

    @ApiModelProperty(name = "num", value = "商品数量")
    private String num;
    @ApiModelProperty(name = "reciveName", value = "收货人")
    private String reciveName;
    @ApiModelProperty(name = "recivePhone", value = "手机")
    private String recivePhone;
    @ApiModelProperty(name = "address", value = "地址")
    private String address;

    /** 物流公司编码 */
    @ApiModelProperty(name="shippingCompanyCode",value = "物流公司编码")
    private String shippingCompanyCode;
    /** 物流公司 */
    @ApiModelProperty(name="shippingCompany",value = "物流公司")
    private String shippingCompany;
    /** 物流单号 */
    @ApiModelProperty(name="shippingCode",value = "物流单号")
    private String shippingCode;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;


    public String getPreNo() {
        return preNo;
    }

    public void setPreNo(String preNo) {
        this.preNo = preNo;
    }
}