package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyRelConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.GetSubWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyRelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 客户仓库配置表服务接口
*
* @author Ghosn
* @since 2024-10-31
*/
@Api(tags = {"客户仓库配置表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-IWarehouseSupplyRelQueryApi",
    name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
    path = "/v1/warehouse/supply",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IWarehouseSupplyRelQueryApi {

    /**
    * 根据id查询客户仓库配置表
    *
    * @param id 客户仓库配置表id
    * @return   客户仓库配置表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询客户仓库配置表", notes = "根据id查询客户仓库配置表")
    RestResponse<WarehouseSupplyRelRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据客户ID查询客户仓库配置表
     *
     * @param customerId 客户客户ID
     * @return   客户仓库配置表数据
     */
    @GetMapping("/customerId/{customerId}")
    @ApiOperation(value = "根据客户ID查询客户仓库配置表", notes = "根据客户ID查询客户仓库配置表")
    RestResponse<List<WarehouseSupplyRelRespDto>> queryByCustomerId(@PathVariable("customerId") String customerId);

    /**
    * 客户仓库配置表分页数据
    *
    * @param filter   客户仓库配置表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 客户仓库配置表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "客户仓库配置表分页数据", notes = "根据filter查询条件查询客户仓库配置表数据，filter=WarehouseSupplyRelReqDto")
    RestResponse<PageInfo<WarehouseSupplyRelRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 客户仓库配置表分页数据
     *
     * @return 客户仓库配置表分页数据
     */
    @PostMapping("/pagePost")
    @ApiOperation(value = "客户仓库配置表分页数据", notes = "根据filter查询条件查询客户仓库配置表数据，filter=warehouseSupplyRelConfigReqDto")
    RestResponse<PageInfo<WarehouseSupplyRelRespDto>> queryByPagePost(@RequestBody WarehouseSupplyRelReqDto warehouseSupplyRelReqDto,@RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 客户仓库配置表分页数据
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/queryWarehousePage")
    @ApiOperation(value = "客户仓库配置表分页数据", notes = "根据filter查询条件查询客户仓库配置表数据，filter=WarehouseSupplyRelReqDto")
    RestResponse<PageInfo<WarehouseSupplyRelRespDto>> queryWarehousePage(@RequestParam("filter") String filter,
                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 客户仓库配置表分页数据
     * @return
     */
    @PostMapping("/queryWarehousePagePost")
    @ApiOperation(value = "客户仓库配置表分页数据", notes = "根据filter查询条件查询客户仓库配置表数据，filter=WarehouseSupplyRelReqDto")
    RestResponse<PageInfo<WarehouseSupplyRelRespDto>> queryWarehousePagePost(@RequestBody WarehouseSupplyRelReqDto warehouseSupplyRelReqDto,@RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/getSubWarehouse")
    @ApiOperation(value = "查询分仓或默认主仓", notes = "")
    RestResponse<WarehouseSupplyRelRespDto> getSubWarehouse(@RequestBody GetSubWarehouseReqDto reqDto);

}
