package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 库存操作来源类型
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 3:25 下午
 */
public enum CsInventorySourceTypeEnum {
    //出库
    /** 销售出库 **/
    OUT_SALE("out_sale","101","销售出库"),
    /** 下单预占 **/
    OUT_SALE_PREEMPT("out_sale_preempt","108","下单预占"),
    /** 分销出库 **/
    OUT_SEPARATE("out_separate","102","分销出库"),
    OUT_SEPARATE_PREEMPT("out_separate_preempt","1020","分销出库预占"),
    /** 退换货出库 **/
    OUT_BACKTRACK("out_backtrack","103","退换货出库"),
    OUT_BACKTRACK_PREEMPT("out_backtrack_preempt","1030","退换货出库预占"),
    /** 一级退换货出库 **/
    OUT_TOP_BACKTRACK("out_top_backtrack","104","一级退换货出库"),
    OUT_TOP_BACKTRACK_PREEMPT("out_top_backtrack_preempt","1040","一级退换货出库预占"),
    /** 二级退换货出库 **/
    SECOND_OUT_TOP_BACKTRACK("second_out_top_backtrack","110","二级退换货出库"),
    SECOND_OUT_TOP_BACKTRACK_PREEMPT("second_out_top_backtrack_preempt","1100","二级退换货出库预占"),
    /** 调拨出库 **/
    OUT_ALLOT("out_allot","105","调拨出库"),
    /** 调拨出库预占 **/
    OUT_ALLOT_PREEMPT("out_allot_preempt","1050","调拨出库预占"),
    /** 其他出库 **/
    OUT_OTHER("out_other","106","其他出库"),
    /** 其他出库预占 **/
    OUT_OTHER_PREEMPT("out_other_preempt","1060","其他出库预占"),
    /** 物料调整出库 **/
    OUT_MATERIAL_ADJUST("out_material_adjust","107","物料调整出库"),
    OUT_MATERIAL_ADJUST_PREEMPT("out_material_adjust_preempt","1070","物料调整出库预占"),
    /** 报废出库 **/
    SCRAP_OUT("out_scrap","109","报废出库"),
    /** 活动下单预占 **/
    OUT_ACT_ORDER_PREEMPT("out_act_order_preempt","302","活动下单预占"),
    /** 活动发货扣减 **/
    OUT_ACT_DELIVER_DEDUCTION("out_act_deliver_deduction","306","活动发货扣减"),
    /** 活动审批预占 **/
    OUT_ACT_AUDIT_PREEMPT("out_act_audit_preempt","307","活动审批预占"),
    /** 业务审批预占 **/
    OUT_BUSINESS_APPROVE_PREEMPT("out_business_approve_preempt","401","业务审批预占"),
    /** 财务审批预占 **/
    OUT_FINANCE_APPROVE_PREEMPT("out_finance_approve_preempt","402","财务审批预占"),
    /** 内部调整出库 **/
    OUT_INTERIOR_ADJUST("out_interior_adjust","502","内部调整出库"),
    OUT_INTERIOR_ADJUST_PREEMPT("out_interior_adjust_preempt","5020","内部调整出库预占"),
    /** 调整单（出库）减少 **/
    OUT_TO_ADJUST("out_to_adjust","601","调整单（出库）减少"),

    OUT_ROLLBACK_ADJUST("out_rollback_adjust","801","调整返还库存"),
    OUT_ROLLBACK_ADJUST_PREEMPT("out_rollback_adjust_preempt","10801","调整返还库存预占"),


    //入库
    /** 采购入库 **/
    IN_PURCHASE("in_purchase","201","采购入库"),
    /** 分销入库 **/
    IN_SEPARATE("in_separate","202","分销入库"),
    /** 退换货入库 **/
    IN_BACKTRACK("in_backtrack","203","退换货入库"),
    /** 下级退换货入库 **/
    IN_DOWN_BACKTRACK("in_down_backtrack","204","下级退换货入库"),
    /** 调拨入库 **/
    IN_ALLOT("in_allot","205","调拨入库"),
    /** 调拨入库 **/
    IN_OTHER("in_other","206","其他入库"),
    /** 物料调整入库 **/
    IN_MATERIAL_ADJUST("in_material_adjust","207","物料调整入库"),
    /** 释放下单的预占 **/
    IN_SALE_RELEASE("in_sale_release","209","订单取消释放"),// 这里和 中b退货入库  共用编码了 但是没关系也能用


    INVOKE_CUBE_ORDER_AH_TRADE("invokeCubeOrderType", "911", "安徽新系统销售出库"), // 在if判断了枚举 可以直接出库 不校验预占
    INVOKE_CUBE_ORDER_AH_RETURN("invokeCubeOrderType", "912", "安徽新系统退货入库"), // 在else的不校验原单逻辑里面 可以直接入库



    /** 二级采购入库 **/
    SECOND_IN_PURCHASE("second_in_purchase","210","二级采购入库"),

    /** 订单修改明细释放 **/
    IN_SALE_MODIFY_RELEASE("in_sale_modify_release","410","订单明细变更释放"),
    /** 业务审批释放 **/
    IN_BUSINESS_APPROVE_RELEASE("in_business_approve_release","501","业务审批释放"),
    /** 财务审批释放 **/
    IN_FINANCE_APPROVE_RELEASE("in_finance_approve_release","502","财务审批释放"),
    /** 订单捕获异常释放 **/
    IN_ORDER_CATCH_RELEASE("in_order_catch_release","601","单据捕获异常释放"),
    /** 活动取消预占 **/
    IN_ACT_CANCEL_PREEMPT("in_act_cancel_preempt","303","活动取消预占"),
    /** 活动结束归还 **/
    IN_ACT_FINISH_BACKTRACK("in_act_finish_backtrack","304","活动结束归还"),
    /** 活动审批释放 **/
    IN_ACT_AUDIT_RELEASE("in_act_audit_release","305","活动审批释放"),

    /** 库存初始化 **/
    INITIALIZE_INVENTORY("initialize_inventory","208","库存初始化/盘点"),
    /** 盘点入库 **/
    CHECK_INVENTORY("check_inventory","666","盘点入库"),
    /** 调整单（入库）增加 **/
    IN_TO_ADJUST("in_to_adjust","602","调整单（入库）增加")
    ;

    private String code;

    private String value;

    private String desc;

    CsInventorySourceTypeEnum(String code, String value, String desc) {
        this.code = code;
        this.value = value;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 根据编码获取枚举
     *
     * @param code
     * @return
     */
    public static CsInventorySourceTypeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsInventorySourceTypeEnum.values()).stream().filter(eo->code.equals(eo.getCode())).findAny().orElse(null);
    }

    /**
     * 根据类型参数获取枚举
     *
     * @param value
     * @return
     */
    public static CsInventorySourceTypeEnum getByValue(String value){
        if(StringUtils.isBlank(value)){
            return null;
        }
        return Arrays.asList(CsInventorySourceTypeEnum.values()).stream().filter(eo->value.equals(eo.getValue())).findAny().orElse(null);
    }
}
