/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.cs;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsLogisticsInfoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogisticsInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogisticsInfoSyncDto;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@MQDesc(tag="LOGISTICS_TRAJECTORY", topic="${OP_EXTERNAL_TOPIC:OP_EXTERNAL_TOPIC}")
@Deprecated
public class LogisticsInformationSyncProcess
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(LogisticsInformationSyncProcess.class);
    @Resource
    private CsLogisticsInfoDas logisticsInfoDas;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(String message) {
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684\u65b0\u589e\u7269\u6d41\u4fe1\u606f\uff0cmessage\uff1a{}", (Object)LogUtils.buildLogContent(message));
        Mutex mutex = null;
        try {
            CsLogisticsInfoSyncDto csLogisticsInfoSyncDto = (CsLogisticsInfoSyncDto)JSON.parseObject((String)message, CsLogisticsInfoSyncDto.class);
            List dataInfoList = csLogisticsInfoSyncDto.getDataInfoList();
            mutex = this.lockService.lock("LOGISTICS_INFO_SYNC", ((CsLogisticsInfoSyncDto.DataInfo)dataInfoList.get(0)).getConsignmentNo());
            if (null == mutex) {
                throw new BizException("\u8ba2\u5355\u540c\u6b65\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            this.logisticsInfoSync(dataInfoList);
            this.lockService.unlock(mutex);
        }
        catch (Exception e) {
            log.error("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684\u65b0\u589e\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
            MessageResponse messageResponse = MessageResponse.ERROR;
            return messageResponse;
        }
        finally {
            this.lockService.unlock(mutex);
        }
        log.info("\u63a5\u53d7\u63a5\u53e3\u4e2d\u5fc3\u540c\u6b65\u7684\u65b0\u589e\u7269\u6d41\u4fe1\u606f\u5b8c\u6bd5");
        return MessageResponse.SUCCESS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void logisticsInfoSync(List<CsLogisticsInfoSyncDto.DataInfo> dataInfoList) {
        ArrayList logisticsInfoEoList = new ArrayList();
        dataInfoList.forEach(info -> {
            CsLogisticsInfoEo logisticsInfoEo = new CsLogisticsInfoEo();
            CubeBeanUtils.copyProperties((Object)logisticsInfoEo, (Object)info, (String[])new String[0]);
            if (StringUtils.isNotBlank((CharSequence)info.getOperTime())) {
                logisticsInfoEo.setOperTime(DateUtil.parseDate((String)info.getOperTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getActualArrivalTime())) {
                logisticsInfoEo.setActualArrivalTime(DateUtil.parseDate((String)info.getActualArrivalTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getCreateTime())) {
                logisticsInfoEo.setCreateTime(DateUtil.parseDate((String)info.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            logisticsInfoEoList.add(logisticsInfoEo);
        });
        if (CollectionUtils.isNotEmpty(logisticsInfoEoList)) {
            this.logisticsInfoDas.insertBatch(logisticsInfoEoList);
        }
    }
}

