/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.AbstractCsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.anno.CsBasicsOrderOperateStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsQualityInfoDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsOverchargeAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderItemStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@CsBasicsOrderOperateStrategy(strategyName="inOutResultOrder")
@Component(value="CsinOutResultOrderbasicsOrderStrategyService")
public class CsInOutResultOrderOperateServiceImpl
extends AbstractCsBasicsOrderOperateService {
    private static final Logger logger = LoggerFactory.getLogger(CsInOutResultOrderOperateServiceImpl.class);
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private CsQualityInfoDetailDas qualityInfoDetailDas;

    @Override
    public Boolean relieveOvercharge(String documentNo) {
        return true;
    }

    @Override
    public Boolean relieveOvercharge(CsOverchargeAdjustReqDto overchargeAdjustReqDto) {
        return true;
    }

    private Long generateInOutOrder(CsBasicsOrderReqDto csBasicsOrderReqDto) {
        List consignNoList;
        InOutResultOrderEo outResultOrderEo = new InOutResultOrderEo();
        String documentNo = csBasicsOrderReqDto.getDocumentNo();
        if (StringUtils.isEmpty((CharSequence)documentNo)) {
            documentNo = BasicsOrderOperateTypeEnum.OUT.getCode().equals(csBasicsOrderReqDto.getBasicsOrderOperateType()) ? GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OUT_RESULT_ORDER.getCode()).getCode() : GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.IN_RESULT_ORDER.getCode()).getCode();
            csBasicsOrderReqDto.setDocumentNo(documentNo);
        }
        outResultOrderEo.setDocumentNo(documentNo);
        outResultOrderEo.setRelevanceTableName(csBasicsOrderReqDto.getRelevanceTableName());
        outResultOrderEo.setPreOrderNo(csBasicsOrderReqDto.getPreOrderNo());
        outResultOrderEo.setRelevanceNo(csBasicsOrderReqDto.getRelevanceNo());
        outResultOrderEo.setExternalOrderNo(csBasicsOrderReqDto.getExternalOrderNo());
        outResultOrderEo.setBusinessType(csBasicsOrderReqDto.getBusinessType());
        outResultOrderEo.setOrderStatus(csBasicsOrderReqDto.getOrderStatus());
        if (CsRelevanceTableNameEnum.CS_BATCH_ADJUSTMENT_ORDER.getCode().equals(csBasicsOrderReqDto.getRelevanceTableName())) {
            outResultOrderEo.setOutLogicWarehouseCode(csBasicsOrderReqDto.getLogicWarehouseCode());
            outResultOrderEo.setOutLogicWarehouseName(csBasicsOrderReqDto.getLogicWarehouseName());
            outResultOrderEo.setOutPhysicsWarehouseCode(csBasicsOrderReqDto.getPhysicsWarehouseCode());
            outResultOrderEo.setOutPhysicsWarehouseName(csBasicsOrderReqDto.getPhysicsWarehouseName());
            outResultOrderEo.setInLogicWarehouseCode(csBasicsOrderReqDto.getLogicWarehouseCode());
            outResultOrderEo.setInLogicWarehouseName(csBasicsOrderReqDto.getLogicWarehouseName());
            outResultOrderEo.setInPhysicsWarehouseCode(csBasicsOrderReqDto.getPhysicsWarehouseCode());
            outResultOrderEo.setInPhysicsWarehouseName(csBasicsOrderReqDto.getPhysicsWarehouseName());
        } else if (BasicsOrderOperateTypeEnum.OUT.getCode().equals(csBasicsOrderReqDto.getBasicsOrderOperateType())) {
            outResultOrderEo.setOutLogicWarehouseName(csBasicsOrderReqDto.getLogicWarehouseCode());
            outResultOrderEo.setOutLogicWarehouseName(csBasicsOrderReqDto.getLogicWarehouseName());
            outResultOrderEo.setOutPhysicsWarehouseCode(csBasicsOrderReqDto.getPhysicsWarehouseCode());
            outResultOrderEo.setOutPhysicsWarehouseName(csBasicsOrderReqDto.getPhysicsWarehouseName());
        } else {
            outResultOrderEo.setInLogicWarehouseCode(csBasicsOrderReqDto.getLogicWarehouseCode());
            outResultOrderEo.setInLogicWarehouseName(csBasicsOrderReqDto.getLogicWarehouseName());
            outResultOrderEo.setInPhysicsWarehouseCode(csBasicsOrderReqDto.getPhysicsWarehouseCode());
            outResultOrderEo.setInPhysicsWarehouseName(csBasicsOrderReqDto.getPhysicsWarehouseName());
        }
        if (CsBusinessCallBackStrategyEnum.BATCH_ADJUSTMENT_ORDER.getCode().equals(csBasicsOrderReqDto.getRelevanceTableName())) {
            outResultOrderEo.setInOutTime(new Date());
        }
        outResultOrderEo.setOrderType(BasicsOrderOperateTypeEnum.OUT.getCode().equals(csBasicsOrderReqDto.getBasicsOrderOperateType()) ? "out" : "in");
        outResultOrderEo.setTotalQuantity(csBasicsOrderReqDto.getTotalQuantity() == null ? BigDecimal.ZERO : csBasicsOrderReqDto.getTotalQuantity());
        outResultOrderEo.setRemark(csBasicsOrderReqDto.getRemark());
        outResultOrderEo.setExtension(csBasicsOrderReqDto.getExtension());
        if (CollectionUtils.isNotEmpty((Collection)csBasicsOrderReqDto.getShippingInfoReqDtoList()) && CollectionUtils.isNotEmpty(consignNoList = csBasicsOrderReqDto.getShippingInfoReqDtoList().stream().map(obj -> obj.getConsignNo()).collect(Collectors.toList()))) {
            String consignNo = consignNoList.stream().collect(Collectors.joining(","));
            outResultOrderEo.setConsignmentNo(consignNo);
        }
        List reqDtoList = csBasicsOrderReqDto.getOrderBasicsDetailReqDtoList();
        ArrayList<InOutResultOrderDetailEo> detailEoList = new ArrayList<InOutResultOrderDetailEo>(reqDtoList.size());
        for (CsBasicsOrderDetailReqDto d : reqDtoList) {
            InOutResultOrderDetailEo detailEo = new InOutResultOrderDetailEo();
            detailEo.setSkuCode(d.getLongCode());
            detailEo.setSkuName(d.getItemName());
            detailEo.setBatch(d.getBatch());
            detailEo.setDocumentNo(documentNo);
            detailEo.setPlanQuantity(d.getQuantity());
            detailEo.setWaitQuantity(BigDecimal.ZERO);
            detailEo.setCancelQuantity(BigDecimal.ZERO);
            detailEo.setDoneQuantity(d.getQuantity());
            detailEo.setQuantity(d.getQuantity());
            detailEo.setExternalOrderNo(csBasicsOrderReqDto.getExternalOrderNo());
            detailEo.setPreOrderNo(csBasicsOrderReqDto.getPreOrderNo());
            detailEo.setRelevanceNo(csBasicsOrderReqDto.getRelevanceNo());
            detailEo.setRemark("init");
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode());
            detailEo.setExtension(d.getExtension());
            detailEoList.add(detailEo);
        }
        this.inOutResultOrderDomain.insert((BaseEo)outResultOrderEo);
        this.inOutResultOrderDetailDomain.insertBatch(detailEoList);
        CsOrderBusinessCallBackContext context = new CsOrderBusinessCallBackContext();
        CsInOutResultRespDto csInOutResultRespDto = new CsInOutResultRespDto();
        context.setCsInOutResultRespDto(csInOutResultRespDto);
        CubeBeanUtils.copyProperties((Object)csInOutResultRespDto, (Object)outResultOrderEo, (String[])new String[0]);
        ArrayList inOutResultDetailRespDtoList = Lists.newArrayList();
        csInOutResultRespDto.setInOutResultDetailRespDtoList((List)inOutResultDetailRespDtoList);
        CubeBeanUtils.copyCollection((Collection)inOutResultDetailRespDtoList, detailEoList, CsInOutResultDetailRespDto.class);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)csBasicsOrderReqDto.getRelevanceTableName());
        if (null == callBackStrategyEnum) {
            return outResultOrderEo.getId();
        }
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        context.setCsBasicsOrderReqDto(csBasicsOrderReqDto);
        context.setInFlag(Boolean.valueOf(false));
        if (BasicsOrderOperateTypeEnum.IN.getCode().equals(csBasicsOrderReqDto.getBasicsOrderOperateType())) {
            context.setInFlag(Boolean.valueOf(true));
        }
        context.setRelevanceNo(outResultOrderEo.getRelevanceNo());
        context.setDocumentNo(documentNo);
        context.setInResultOrderNo(documentNo);
        businessOrderCallBackService.inOutResultOrderCallBack(context);
        return outResultOrderEo.getId();
    }
}

