/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.TypeReference;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDocumentExpressReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csDeliveryResultOrderService")
public class CsDeliveryResultOrderServiceImpl
implements ICsDeliveryResultOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsDeliveryResultOrderServiceImpl.class);
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    private ICsOutResultOrderQueryService csOutResultOrderQueryService;
    @Resource
    private ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    private CsCommonService csCommonService;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    public Long add(CsDeliveryResultOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u53d1\u8d27\u5355\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        String relevanceNo = addReqDto.getRelevanceNo();
        this.repeatFilter.checkRepeat("DeliveryNotice:" + addReqDto.getPreOrderNo(), () -> this.preValid(relevanceNo), true);
        this.dataValid(addReqDto);
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)csDeliveryResultOrderEo, (Object)addReqDto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("102");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        csDeliveryResultOrderEo.setDocumentNo(documentNo);
        csDeliveryResultOrderEo.setOrderStatus(orderStatus);
        csDeliveryResultOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)csDeliveryResultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsDeliveryResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ReceiveDeliveryResultOrderDetailEo eo = new ReceiveDeliveryResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)eo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)eo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            eo.setDocumentNo(documentNo);
            detailEoList.add(eo);
        }
        this.receiveDeliveryResultOrderDetailDomain.insertBatch((List)detailEoList);
        return csDeliveryResultOrderEo.getId();
    }

    @Override
    public void update(Long id, CsDeliveryResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ReceiveDeliveryResultOrderEo updateEo = new ReceiveDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.receiveDeliveryResultOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
    }

    public void dataValid(CsDeliveryResultOrderAddReqDto addReqDto) {
        List<RelWarehouseEo> relPhysicList;
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getPreOrderNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)BusinessTypeEnum.getDescByCode((String)addReqDto.getBusinessType())), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List logicWarehouseEos = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{addReqDto.getWarehouseCode()}));
        List itemList = addReqDto.getDetailAddReqDtoList().stream().map(CsDeliveryResultOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(itemList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        List itemEoList = this.itemSkuProxy.queryBySkuCodes(itemList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemEoList), "\u5546\u54c1\u672a\u914d\u7f6e");
        if (itemEoList.size() != itemEoList.size()) {
            logger.info("error,\u8d27\u54c1\u4e0d\u4e00\u81f4\uff0c\u540e\u7eed\u5904\u7406\uff1b");
        }
        if (CollectionUtils.isNotEmpty(relPhysicList = this.csRelWarehouseQueryService.queryByRefWarehouseCode(addReqDto.getWarehouseCode(), CsWarehouseClassifyEnum.LOGIC.getCode()))) {
            addReqDto.setDeliveryPhysicsWarehouseCode(relPhysicList.get(0).getRefWarehouseCode());
            addReqDto.setDeliveryPhysicsWarehouseName(relPhysicList.get(0).getRefWarehouseName());
        }
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        Map<String, ItemSkuDto> cargoMap = itemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
        for (CsDeliveryResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ItemSkuDto itemEo = cargoMap.get(detailAddReqDto.getCargoCode());
            if (null == itemEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            detailAddReqDto.setCargoId(itemEo.getId());
            detailAddReqDto.setCargoName(itemEo.getSkuName());
        }
    }

    @Override
    public void updateExpressInfo(CsDocumentExpressReqDto reqDto) {
        List list = this.receiveDeliveryResultOrderDomain.queryByDocumentNo(reqDto.getDocumentNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u636e\u4e0d\u5b58\u5728");
        ReceiveDeliveryResultOrderEo eo = new ReceiveDeliveryResultOrderEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)eo);
        eo.setId(((ReceiveDeliveryResultOrderEo)list.get(0)).getId());
        this.receiveDeliveryResultOrderDomain.getMapper().updateById((BaseEo)eo);
    }

    @Override
    public Long createDeliveryResultOrder(String relevanceNo, String preOrderNo) {
        this.repeatFilter.checkRepeat("DeliveryResult:" + relevanceNo + preOrderNo, () -> this.preValid(relevanceNo), true);
        String outResultDocumentNo = this.csOutResultOrderQueryService.queryDocumentByPreOrderNo(preOrderNo);
        CsOutResultOrderRespDto dto = this.csOutResultOrderQueryService.queryByDocumentNo2(outResultDocumentNo);
        CsDeliveryNoticeOrderRespDto deliveryNoticeOrderRespDto = this.csDeliveryNoticeOrderQueryService.queryByPreOrderNo(dto.getPreOrderNo());
        dto.setWarehouseId(deliveryNoticeOrderRespDto.getWarehouseId());
        dto.setWarehouseCode(deliveryNoticeOrderRespDto.getWarehouseCode());
        dto.setWarehouseName(deliveryNoticeOrderRespDto.getWarehouseName());
        dto.setOrganizationId(deliveryNoticeOrderRespDto.getOrganizationId());
        dto.setOrganizationName(deliveryNoticeOrderRespDto.getOrganizationName());
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)csDeliveryResultOrderEo, (Object)dto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.pcpGenerateCode("102");
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.DELIVERY_RESULT_ORDE.getCode()).getCode();
        String orderStatus = generateCodeEnum.getStatus();
        csDeliveryResultOrderEo.setDocumentNo(documentNo);
        csDeliveryResultOrderEo.setOrderStatus(orderStatus);
        csDeliveryResultOrderEo.setRelevanceNo(relevanceNo);
        csDeliveryResultOrderEo.setExtension(dto.getExtension());
        CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
        queryDto.setWarehouseId(csDeliveryResultOrderEo.getWarehouseId());
        queryDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        queryDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        List<CsRelWarehouseRespDto> csRelWarehouseRespDtos = this.csRelWarehouseQueryService.queryWarehouseByConditions(queryDto);
        if (CollectionUtils.isNotEmpty(csRelWarehouseRespDtos)) {
            csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(csRelWarehouseRespDtos.get(0).getRefWarehouseName());
            csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(csRelWarehouseRespDtos.get(0).getRefWarehouseCode());
        }
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)csDeliveryResultOrderEo);
        Map<String, Long> activityIdMap = this.queryActivityMap(relevanceNo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsOutResultOrderDetailRespDto detailRespDto : dto.getDetailRespDtoList()) {
            ReceiveDeliveryResultOrderDetailEo detailEo = new ReceiveDeliveryResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailRespDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEo.setRelevanceNo(relevanceNo);
            detailEo.setActivityId(activityIdMap.get(detailRespDto.getCargoCode() + detailRespDto.getBatch() + detailRespDto.getTradeOrderItemId()));
            detailEoList.add(detailEo);
        }
        this.receiveDeliveryResultOrderDetailDomain.insertBatch((List)detailEoList);
        return csDeliveryResultOrderEo.getId();
    }

    @Override
    public void updateExtension(CsDeliveryResultOrderUpdateReqDto reqDto) {
        Map map;
        logger.info("\u66f4\u65b0\u6536\u53d1\u8d27\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isEmpty((Object)reqDto.getExtensionMap())) {
            logger.info("\u65e0\u9700\u4fdd\u5b58\u6269\u5c55\u4fe1\u606f");
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getId()) && StringUtils.isNotBlank((CharSequence)reqDto.getDocumentNo())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5931\u8d25");
        }
        ReceiveDeliveryResultOrderEo queryEo = new ReceiveDeliveryResultOrderEo();
        queryEo.setId(reqDto.getId());
        queryEo.setDocumentNo(reqDto.getDocumentNo());
        ReceiveDeliveryResultOrderEo eo = (ReceiveDeliveryResultOrderEo)this.receiveDeliveryResultOrderDomain.selectOne((BaseEo)queryEo);
        if (ObjectUtil.isEmpty((Object)eo)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6536\u53d1\u7ed3\u679c\u5355\u4fe1\u606f");
        }
        ReceiveDeliveryResultOrderEo updateEo = new ReceiveDeliveryResultOrderEo();
        updateEo.setId(eo.getId());
        if (StringUtils.isNotBlank((CharSequence)eo.getExtension()) && ObjectUtil.isNotEmpty((Object)(map = (Map)JSON.parseObject((String)eo.getExtension(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0])))) {
            reqDto.getExtensionMap().putAll(map);
        }
        updateEo.setExtension(JSON.toJSONString((Object)reqDto.getExtensionMap()));
        this.receiveDeliveryResultOrderDomain.updateSelective((BaseEo)updateEo);
    }

    private Map<String, Long> queryActivityMap(String relevanceNo) {
        HashMap<String, Long> activityIdMap = new HashMap<String, Long>();
        List noticeOrderDetailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByDocumentNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)noticeOrderDetailEoList)) {
            for (ReceiveDeliveryNoticeOrderDetailEo detailEo : noticeOrderDetailEoList) {
                activityIdMap.put(detailEo.getSkuCode() + detailEo.getBatch() + detailEo.getPreOrderItemId(), detailEo.getActivityId());
            }
        }
        return activityIdMap;
    }

    private void preValid(String relevanceNo) {
        List oldList = this.receiveDeliveryResultOrderDomain.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (ReceiveDeliveryResultOrderEo deliveryResultOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(deliveryResultOrderEo.getOrderStatus()), deliveryResultOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }
}

