/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics;

import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.ICsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsOverchargeAdjustReqDto;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCsBasicsOrderOperateService
implements ICsBasicsOrderOperateService {
    protected final String INIT = "init";
    @Resource
    private CsCommonService csCommonService;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    public void updateStatusByDocumentNo(String documentNo, String orderStatus) {
    }

    @Override
    public Boolean relieveOvercharge(String documentNo) {
        return null;
    }

    @Override
    public Boolean relieveOvercharge(CsOverchargeAdjustReqDto overchargeAdjustReqDto) {
        return null;
    }

    @Override
    public void sendWms(String documentNo) {
    }

    protected void checkParams(CsBasicsOrderReqDto orderReqDto) {
        AssertUtil.isTrue(null != orderReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String relevanceNo = orderReqDto.getRelevanceNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)relevanceNo), "\u5173\u8054\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String businessType = orderReqDto.getBusinessType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)businessType), "\u4e1a\u52a1\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String relevanceTableName = orderReqDto.getRelevanceTableName();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)relevanceTableName), "\u4e1a\u52a1\u5355\u636e\u8868\u540d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String basicsOrderOperateType = orderReqDto.getBasicsOrderOperateType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)basicsOrderOperateType) && null != BasicsOrderOperateTypeEnum.getByCode((String)basicsOrderOperateType), "\u64cd\u4f5c\u6807\u8bc6\u53c2\u6570\u6709\u8bef");
        List orderBasicsDetailReqDtoList = orderReqDto.getOrderBasicsDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderBasicsDetailReqDtoList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        orderBasicsDetailReqDtoList.forEach(dto -> {
            String longCode = dto.getLongCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)longCode), "\u5546\u54c1\u957f\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal quantity = dto.getQuantity();
            AssertUtil.isTrue(null != quantity && quantity.compareTo(BigDecimal.ZERO) >= 0, "\u5546\u54c1\u6570\u91cf\u53c2\u6570\u6709\u8bef");
        });
        List longCodeList = orderBasicsDetailReqDtoList.stream().map(CsBasicsOrderDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        List csItemEoList = this.itemSkuProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csItemEoList), "\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
        Map itemEoMap = csItemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        for (CsBasicsOrderDetailReqDto basicsOrderDetailReqDto : orderBasicsDetailReqDtoList) {
            String longCode = basicsOrderDetailReqDto.getLongCode();
            ItemSkuDto csItemEo = (ItemSkuDto)itemEoMap.get(longCode);
            AssertUtil.isTrue(null != csItemEo, "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            basicsOrderDetailReqDto.setItemName(csItemEo.getSkuName());
            basicsOrderDetailReqDto.setArtNo(csItemEo.getSkuCode());
        }
    }
}

