/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.TransferOrderApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IInternalTradeExtService;
import com.dtyunxi.yundt.cube.center.inventory.constant.InternalTradeStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.InternalTradeDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.InternalTradeEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.external.AllotOrderDetailDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.external.AllotOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.InternalTradeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class InternalTradeExtServiceImpl
implements IInternalTradeExtService {
    private static final Logger logger = LoggerFactory.getLogger(InternalTradeExtServiceImpl.class);
    @Resource
    private InternalTradeDas internalTradeDas;
    @Resource
    private ICsInventoryExposedService csInventoryExposedService;
    @Resource
    private ICsTransferOrderService csTransferOrderService;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource(name="tcbj_TransferOrderApi")
    private TransferOrderApiImpl csTransferOrderApiImpl;

    @Override
    @Retryable(value={BizException.class}, maxAttempts=5, backoff=@Backoff(delay=1800L, multiplier=1.5))
    public void preemptionTrade(InternalTradeReqDto reqDto) {
        logger.info("\u9884\u5360\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getContent()) || ObjectUtil.isEmpty((Object)reqDto.getId())) {
            logger.info("\u9884\u5360\u5185\u90e8\u4ea4\u6613\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
            return;
        }
        AllotOrderDto allot = (AllotOrderDto)JSON.parseObject((String)reqDto.getContent(), AllotOrderDto.class);
        if (reqDto.getBusinessType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode())) {
            try {
                CsInventoryOperateReqDto csInventoryOperateReqDto = this.inventoryOperateBuild(allot);
                this.csInventoryExposedService.batchPreemptInventory(Lists.newArrayList((Object[])new CsInventoryOperateReqDto[]{csInventoryOperateReqDto}));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                InternalTradeEo updateEo = new InternalTradeEo();
                updateEo.setId(reqDto.getId());
                updateEo.setStatus(InternalTradeStatusEnum.EXCEPTION.getCode());
                updateEo.setRemark("\u6267\u884c\u5f02\u5e38\uff0c\u9884\u5360\u5931\u8d25\uff1a" + e.getMessage());
                this.internalTradeDas.update((BaseEo)updateEo);
                throw new BizException("-1", "\u6267\u884c\u5f02\u5e38\uff0c\u9884\u5360\u5931\u8d25");
            }
        }
    }

    @Override
    @Retryable(value={BizException.class}, maxAttempts=5, backoff=@Backoff(delay=1800L, multiplier=1.5))
    public void createTrade(InternalTradeReqDto reqDto) {
        logger.info("\u521b\u5efa\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getContent()) || ObjectUtil.isEmpty((Object)reqDto.getId())) {
            logger.info("\u9884\u5360\u5185\u90e8\u4ea4\u6613\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
            return;
        }
        AllotOrderDto allot = (AllotOrderDto)JSON.parseObject((String)reqDto.getContent(), AllotOrderDto.class);
        InternalTradeEo updateEo = new InternalTradeEo();
        updateEo.setId(reqDto.getId());
        try {
            EasTransferOrderReqDto easTransferOrderReqDto = this.easTransferOrderBuild(allot);
            this.csTransferOrderApiImpl.batchEasAddTransferOrder(Lists.newArrayList((Object[])new EasTransferOrderReqDto[]{easTransferOrderReqDto}));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            updateEo.setStatus(InternalTradeStatusEnum.EXCEPTION.getCode());
            updateEo.setRemark("\u6267\u884c\u5f02\u5e38\uff0c\u521b\u5efa\u5355\u636e\u5931\u8d25\uff1a" + e.getMessage());
            this.internalTradeDas.update((BaseEo)updateEo);
            throw new BizException("-1", "\u6267\u884c\u5f02\u5e38\uff0c\u521b\u5efa\u5355\u636e\u5931\u8d25");
        }
        updateEo.setStatus(InternalTradeStatusEnum.UNDER_WAY.getCode());
        updateEo.setRemark("\u8fdb\u884c\u4e2d");
        this.internalTradeDas.update((BaseEo)updateEo);
    }

    private CsInventoryOperateReqDto inventoryOperateBuild(AllotOrderDto allot) {
        logger.info("\u6279\u91cf\u9884\u5360\u6570\u636e\u6784\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)allot));
        CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
        BeanUtil.copyProperties((Object)allot, (Object)csInventoryOperateReqDto, (String[])new String[0]);
        csInventoryOperateReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
        csInventoryOperateReqDto.setSourceNo(allot.getExternalSaleOrderNo());
        csInventoryOperateReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
        csInventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT.getCode());
        csInventoryOperateReqDto.setBusinessType(CsPcpBusinessTypeEnum.ALLOT_OUT.getCode());
        csInventoryOperateReqDto.setBatchCalculate(Boolean.valueOf(true));
        csInventoryOperateReqDto.setNegativeValidate(Integer.valueOf(1));
        ArrayList inventoryOperateCargoReqDtoList = new ArrayList();
        ArrayList itemDetailList = new ArrayList();
        allot.getItemDetailList().forEach(item -> {
            CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(item.getSkuCode());
            inventoryOperateCargoReqDto.setWarehouseCode(item.getOutWarehouseCode());
            inventoryOperateCargoReqDto.setChangeInventory(item.getQuantity());
            inventoryOperateCargoReqDto.setBatch(item.getBatch());
            inventoryOperateCargoReqDtoList.add(inventoryOperateCargoReqDto);
        });
        csInventoryOperateReqDto.setOperateCargoReqDtoList(inventoryOperateCargoReqDtoList);
        return csInventoryOperateReqDto;
    }

    private EasTransferOrderReqDto easTransferOrderBuild(AllotOrderDto allot) {
        EasTransferOrderReqDto easTransferOrderReqDto = new EasTransferOrderReqDto();
        easTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
        easTransferOrderReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
        easTransferOrderReqDto.setParentOrderNo(allot.getPlatformOrderParentNo());
        easTransferOrderReqDto.setExternalSaleOrderNo(allot.getExternalSaleOrderNo());
        easTransferOrderReqDto.setExternalPurchaseOrderNo(allot.getExternalPurchaseOrderNo());
        easTransferOrderReqDto.setAllotType(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode());
        easTransferOrderReqDto.setSupplierCode(allot.getSupplierCode());
        easTransferOrderReqDto.setInWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getInWarehouseCode());
        easTransferOrderReqDto.setOutWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getOutWarehouseCode());
        HashMap<String, Object> extensionMap = new HashMap<String, Object>();
        if (allot.getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode())) {
            extensionMap.put(EASExtendKeyEnum.F_COMPANY_ORG.code, allot.getInInventoryOrgCode());
        } else {
            extensionMap.put(EASExtendKeyEnum.F_COMPANY_ORG.code, allot.getOutInventoryOrgCode());
        }
        extensionMap.put(EASExtendKeyEnum.SOURCE_NUM.code, allot.getExternalPurchaseOrderNo());
        extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, allot.getExternalPurchaseOrderId());
        extensionMap.put(EASExtendKeyEnum.SALE_ORDER_NO.code, allot.getExternalSaleOrderNo());
        extensionMap.put(EASExtendKeyEnum.SALE_ORDER_ID.code, allot.getExternalSaleOrderId());
        extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, allot.getExternalPurchaseOrderId());
        extensionMap.put(EASExtendKeyEnum.SALE_ORG_CODE.code, allot.getSaleOrganizationCode());
        extensionMap.put(EASExtendKeyEnum.SALE_CUS_CODE.code, allot.getSaleCustomerCode());
        extensionMap.put(EASExtendKeyEnum.ITEM_TOTAL_AMOUNT.code, allot.getItemTotalAmount());
        easTransferOrderReqDto.setExtension(JSON.toJSONString(extensionMap));
        easTransferOrderReqDto.setRemark(allot.getRemark());
        List<String> longCodes = allot.getItemDetailList().stream().map(AllotOrderDetailDto::getSkuCode).collect(Collectors.toList());
        Map<String, PcpItemRespDto> map = this.queryItemInfo(longCodes);
        ArrayList itemDetailList = new ArrayList();
        allot.getItemDetailList().forEach(item -> {
            PcpItemRespDto pcpItemRespDto;
            EasTransferOrderDetailReqDto easTransferOrderDetailReqDto = new EasTransferOrderDetailReqDto();
            easTransferOrderDetailReqDto.setLongCode(item.getSkuCode());
            easTransferOrderDetailReqDto.setQuantity(item.getQuantity());
            easTransferOrderDetailReqDto.setBatch(item.getBatch());
            if (ObjectUtil.isNotEmpty((Object)map) && ObjectUtil.isNotEmpty(map.get(item.getSkuCode())) && ObjectUtil.isNotEmpty((Object)(pcpItemRespDto = (PcpItemRespDto)map.get(item.getSkuCode())).getVolume())) {
                easTransferOrderDetailReqDto.setVolume(pcpItemRespDto.getVolume().multiply(item.getQuantity()).setScale(4, RoundingMode.DOWN));
            }
            HashMap<String, Object> itemExtensionMap = new HashMap<String, Object>();
            itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID.code, item.getPurchaseOrderDetailId());
            itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID2.code, item.getSaleOrderDetailId());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_PRICE.code, item.getPrice());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_SALE_PRICE.code, item.getSalePrice());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_ACTUALLY_AMOUNT.code, item.getActuallyAmount());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_PAYABLE_AMOUNT.code, item.getPayableAmount());
            itemExtensionMap.put(EASExtendKeyEnum.DISCOUNT_AMOUNT.code, item.getDiscountAmount());
            itemExtensionMap.put(EASExtendKeyEnum.TAX_RATE.code, item.getTaxRate());
            easTransferOrderDetailReqDto.setExtension(JSON.toJSONString(itemExtensionMap));
            itemDetailList.add(easTransferOrderDetailReqDto);
        });
        easTransferOrderReqDto.setItemDetailList(itemDetailList);
        return easTransferOrderReqDto;
    }

    private Map<String, PcpItemRespDto> queryItemInfo(List<String> longCodes) {
        try {
            logger.info("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(longCodes));
            if (CollectionUtils.isEmpty(longCodes)) {
                return new HashMap<String, PcpItemRespDto>();
            }
            List itemList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                return itemList.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, entity -> entity));
            }
            return new HashMap<String, PcpItemRespDto>();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

