/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckEasReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckItem;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryCheckRespDto;
import com.dtyunxi.tcbj.api.query.IInventoryCheckApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IInternalTradeExtService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IInternalTradeService;
import com.dtyunxi.yundt.cube.center.inventory.constant.InternalTradeStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.InternalTradeDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.InternalTradeEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.InternalTradeMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.external.AllotOrderDetailDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.external.AllotOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.InternalTradeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.InternalTradeRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InternalTradeServiceImpl
implements IInternalTradeService {
    private static final Logger logger = LoggerFactory.getLogger(InternalTradeServiceImpl.class);
    @Resource
    private InternalTradeDas internalTradeDas;
    @Resource
    private InternalTradeMapper internalTradeMapper;
    @Resource
    private IInventoryCheckApi inventoryCheckApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private IInternalTradeExtService internalTradeExtService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchInternalTrade(List<InternalTradeReqDto> reqDtoList) {
        logger.info("\u6279\u91cf\u65b0\u589e\u5185\u90e8\u4ea4\u6613\uff08\u591a\u65b9\u8c03\u62e8\uff09\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        reqDtoList.forEach(dto -> {
            InternalTradeReqDto params = new InternalTradeReqDto();
            params.setNo(dto.getNo());
            params.setNoParent(dto.getNoParent());
            if (CollectionUtil.isNotEmpty(this.queryList(params))) {
                throw new BizException(dto.getNo() + "\uff0c\u5355\u636e\u5df2\u5b58\u5728");
            }
            InternalTradeEo internalTradeEo = new InternalTradeEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)internalTradeEo);
            this.internalTradeDas.insert((BaseEo)internalTradeEo);
        });
    }

    @Override
    public void modifyInternalTrade(InternalTradeReqDto modifyReqDto) {
        logger.info("\u4fee\u6539\u5185\u90e8\u4ea4\u6613\uff08\u591a\u65b9\u8c03\u62e8\uff09\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
        if (ObjectUtil.isEmpty((Object)modifyReqDto) && ObjectUtil.isEmpty((Object)modifyReqDto.getId())) {
            throw new BizException("\u66f4\u65b0\u5931\u8d25\uff0c\u53c2\u6570\u8bf7\u6c42\u6709\u8bef");
        }
        QueryWrapper updateParams = new QueryWrapper();
        updateParams.eq((Object)"dr", (Object)"0");
        if (ObjectUtil.isNotEmpty((Object)modifyReqDto.getId())) {
            updateParams.eq((Object)"id", (Object)modifyReqDto.getId());
        }
        if (ObjectUtil.isNotEmpty((Object)modifyReqDto.getNo())) {
            updateParams.eq((Object)"no", (Object)modifyReqDto.getNo());
        }
        if (ObjectUtil.isNotEmpty((Object)modifyReqDto.getNoParent())) {
            updateParams.eq((Object)"no_parent", (Object)modifyReqDto.getNoParent());
        }
        InternalTradeEo internalTradeEo = new InternalTradeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)internalTradeEo);
        this.internalTradeMapper.update((Object)internalTradeEo, (Wrapper)updateParams);
    }

    @Override
    public void removeInternalTrade(InternalTradeReqDto reqDto) {
        logger.info("\u5220\u9664\u5185\u90e8\u4ea4\u6613\uff08\u591a\u65b9\u8c03\u62e8\uff09\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isEmpty((Object)reqDto.getId()) && ObjectUtil.isEmpty((Object)reqDto.getNoParent()) && ObjectUtil.isEmpty((Object)reqDto.getNo())) {
            throw new BizException("\u5220\u9664\u5931\u8d25\uff0c\u53c2\u6570\u8bf7\u6c42\u6709\u8bef");
        }
        InternalTradeEo internalTradeEo = new InternalTradeEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)internalTradeEo);
        this.internalTradeDas.logicDelete((BaseEo)internalTradeEo);
    }

    @Override
    public void nextInternalTrade(InternalTradeReqDto reqDto) {
        logger.info("\u6267\u884c\u4e0b\u4e00\u4e2a\u4ea4\u6613\uff08\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\uff09\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        InternalTradeReqDto queryParams = new InternalTradeReqDto();
        queryParams.setNo(reqDto.getNo());
        List<InternalTradeRespDto> internalTradeList = this.queryList(queryParams);
        if (CollectionUtil.isEmpty(internalTradeList)) {
            logger.error("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ea4\u6613");
            return;
        }
        InternalTradeRespDto internalTradeRespDto = internalTradeList.get(0);
        InternalTradeReqDto updParams = new InternalTradeReqDto();
        updParams.setId(internalTradeRespDto.getId());
        updParams.setNo(internalTradeRespDto.getNo());
        updParams.setStatus(InternalTradeStatusEnum.FINISHED.getCode());
        updParams.setRemark("\u5df2\u5b8c\u6210");
        this.modifyInternalTrade(updParams);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"no_parent", (Object)internalTradeRespDto.getNoParent());
        queryWrapper.eq((Object)"status", (Object)InternalTradeStatusEnum.WAIT.getCode());
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.orderByAsc((Object)"sort");
        List eoList = this.internalTradeMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)eoList)) {
            logger.info("\u4ea4\u6613\u5df2\u7ecf\u5b8c\u6210\uff0c\u65e0\u540e\u7eed\u4ea4\u6613");
            return;
        }
        logger.info("\u5269\u4f59\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)eoList));
        this.executeNext((InternalTradeEo)eoList.get(0));
    }

    @Override
    public void executeNext(InternalTradeReqDto reqDto) {
        logger.info("\u6267\u884c\u4e0b\u4e00\u4e2a\u4ea4\u6613\uff08\u4e0d\u5904\u7406\u4e0a\u6b21\u4ea4\u6613\uff09\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        InternalTradeEo eo = new InternalTradeEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        this.executeNext(eo);
    }

    @Override
    public List<InternalTradeRespDto> queryList(InternalTradeReqDto reqDto) {
        logger.info("\u67e5\u8be2\u5185\u90e8\u4ea4\u6613\uff08\u591a\u65b9\u8c03\u62e8\uff09\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isEmpty((Object)reqDto.getId()) && ObjectUtil.isEmpty((Object)reqDto.getNo()) && ObjectUtil.isEmpty((Object)reqDto.getNoParent())) {
            throw new BizException("\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        }
        InternalTradeEo paramsEo = new InternalTradeEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)paramsEo);
        paramsEo.setOrderBy("sort");
        List eoList = this.internalTradeDas.select((BaseEo)paramsEo);
        ArrayList<InternalTradeRespDto> dtoList = new ArrayList<InternalTradeRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, InternalTradeRespDto.class);
        return dtoList;
    }

    private void executeNext(InternalTradeEo tradeEo) {
        logger.info("\u6267\u884c\u4e0b\u4e00\u4e2a\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)tradeEo));
        InternalTradeReqDto reqDto = new InternalTradeReqDto();
        DtoHelper.eo2Dto((BaseEo)tradeEo, (BaseVo)reqDto);
        this.internalTradeExtService.preemptionTrade(reqDto);
        this.internalTradeExtService.createTrade(reqDto);
    }

    private CsInventoryOperateReqDto inventoryOperateBuild(AllotOrderDto allot) {
        logger.info("\u6279\u91cf\u9884\u5360\u6570\u636e\u6784\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)allot));
        CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
        BeanUtil.copyProperties((Object)allot, (Object)csInventoryOperateReqDto, (String[])new String[0]);
        csInventoryOperateReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
        csInventoryOperateReqDto.setSourceNo(allot.getExternalSaleOrderNo());
        csInventoryOperateReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
        csInventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT.getCode());
        csInventoryOperateReqDto.setBusinessType(CsPcpBusinessTypeEnum.ALLOT_OUT.getCode());
        csInventoryOperateReqDto.setBatchCalculate(Boolean.valueOf(true));
        csInventoryOperateReqDto.setNegativeValidate(Integer.valueOf(1));
        ArrayList inventoryOperateCargoReqDtoList = new ArrayList();
        ArrayList itemDetailList = new ArrayList();
        allot.getItemDetailList().forEach(item -> {
            CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(item.getSkuCode());
            inventoryOperateCargoReqDto.setWarehouseCode(item.getOutWarehouseCode());
            inventoryOperateCargoReqDto.setChangeInventory(item.getQuantity());
            inventoryOperateCargoReqDto.setBatch(item.getBatch());
            inventoryOperateCargoReqDtoList.add(inventoryOperateCargoReqDto);
        });
        csInventoryOperateReqDto.setOperateCargoReqDtoList(inventoryOperateCargoReqDtoList);
        return csInventoryOperateReqDto;
    }

    private EasTransferOrderReqDto easTransferOrderBuild(AllotOrderDto allot) {
        EasTransferOrderReqDto easTransferOrderReqDto = new EasTransferOrderReqDto();
        easTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
        easTransferOrderReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
        easTransferOrderReqDto.setParentOrderNo(allot.getPlatformOrderParentNo());
        easTransferOrderReqDto.setExternalSaleOrderNo(allot.getExternalSaleOrderNo());
        easTransferOrderReqDto.setExternalPurchaseOrderNo(allot.getExternalPurchaseOrderNo());
        easTransferOrderReqDto.setAllotType(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode());
        easTransferOrderReqDto.setSupplierCode(allot.getSupplierCode());
        easTransferOrderReqDto.setInWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getInWarehouseCode());
        easTransferOrderReqDto.setOutWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getOutWarehouseCode());
        HashMap<String, Object> extensionMap = new HashMap<String, Object>();
        if (allot.getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode())) {
            extensionMap.put(EASExtendKeyEnum.F_COMPANY_ORG.code, allot.getInInventoryOrgCode());
        } else {
            extensionMap.put(EASExtendKeyEnum.F_COMPANY_ORG.code, allot.getOutInventoryOrgCode());
        }
        extensionMap.put(EASExtendKeyEnum.SOURCE_NUM.code, allot.getExternalPurchaseOrderNo());
        extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, allot.getExternalPurchaseOrderId());
        extensionMap.put(EASExtendKeyEnum.SALE_ORDER_NO.code, allot.getExternalSaleOrderNo());
        extensionMap.put(EASExtendKeyEnum.SALE_ORDER_ID.code, allot.getExternalSaleOrderId());
        extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, allot.getExternalPurchaseOrderId());
        extensionMap.put(EASExtendKeyEnum.SALE_ORG_CODE.code, allot.getSaleOrganizationCode());
        extensionMap.put(EASExtendKeyEnum.SALE_CUS_CODE.code, allot.getSaleCustomerCode());
        extensionMap.put(EASExtendKeyEnum.ITEM_TOTAL_AMOUNT.code, allot.getItemTotalAmount());
        easTransferOrderReqDto.setExtension(JSON.toJSONString(extensionMap));
        easTransferOrderReqDto.setRemark(allot.getRemark());
        List<String> longCodes = allot.getItemDetailList().stream().map(AllotOrderDetailDto::getSkuCode).collect(Collectors.toList());
        Map<String, PcpItemRespDto> map = this.queryItemInfo(longCodes);
        ArrayList itemDetailList = new ArrayList();
        allot.getItemDetailList().forEach(item -> {
            PcpItemRespDto pcpItemRespDto;
            EasTransferOrderDetailReqDto easTransferOrderDetailReqDto = new EasTransferOrderDetailReqDto();
            easTransferOrderDetailReqDto.setLongCode(item.getSkuCode());
            easTransferOrderDetailReqDto.setQuantity(item.getQuantity());
            easTransferOrderDetailReqDto.setBatch(item.getBatch());
            if (ObjectUtil.isNotEmpty((Object)map) && ObjectUtil.isNotEmpty(map.get(item.getSkuCode())) && ObjectUtil.isNotEmpty((Object)(pcpItemRespDto = (PcpItemRespDto)map.get(item.getSkuCode())).getVolume())) {
                easTransferOrderDetailReqDto.setVolume(pcpItemRespDto.getVolume().multiply(item.getQuantity()).setScale(4, RoundingMode.DOWN));
            }
            HashMap<String, Object> itemExtensionMap = new HashMap<String, Object>();
            itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID.code, item.getPurchaseOrderDetailId());
            itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID2.code, item.getSaleOrderDetailId());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_PRICE.code, item.getPrice());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_SALE_PRICE.code, item.getSalePrice());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_ACTUALLY_AMOUNT.code, item.getActuallyAmount());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_PAYABLE_AMOUNT.code, item.getPayableAmount());
            itemExtensionMap.put(EASExtendKeyEnum.DISCOUNT_AMOUNT.code, item.getDiscountAmount());
            itemExtensionMap.put(EASExtendKeyEnum.TAX_RATE.code, item.getTaxRate());
            easTransferOrderDetailReqDto.setExtension(JSON.toJSONString(itemExtensionMap));
            itemDetailList.add(easTransferOrderDetailReqDto);
        });
        easTransferOrderReqDto.setItemDetailList(itemDetailList);
        return easTransferOrderReqDto;
    }

    private void verifyChannelSupplyInventory(List<CsInventoryOperateReqDto> orderList) {
        logger.info("\u591a\u65b9\u8c03\u62e8\u4ea4\u6613\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\uff1a{}", (Object)JSON.toJSONString(orderList));
        orderList.forEach(order -> {
            InventoryCheckEasReqDto reqDto = new InventoryCheckEasReqDto();
            reqDto.setType(InventoryCheckEasReqDto.Type.INTERNAL_DEAL_RETURN_TRANSFORM);
            reqDto.setCheckType(InventoryCheckReqDto.CheckType.CHANNEL);
            reqDto.setItems(order.getOperateCargoReqDtoList().stream().map(item -> {
                InventoryCheckItem checkItem = new InventoryCheckItem();
                checkItem.setLongCode(item.getLongCode());
                checkItem.setLogicWarehouseCode(item.getWarehouseCode());
                return checkItem;
            }).collect(Collectors.toList()));
            logger.info("EAS\u53d1\u8d77\u8c03\u62e8\u6821\u9a8c\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            InventoryCheckRespDto respDto = (InventoryCheckRespDto)RestResponseHelper.extractData((RestResponse)this.inventoryCheckApi.checkForEas(reqDto));
            if (!respDto.isCheckResult()) {
                throw new BizException("-1", "\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u5931\u8d25\uff1a" + this.getMsg(respDto.getItems()));
            }
        });
    }

    private String getMsg(List<InventoryCheckItem> items) {
        if (CollectionUtils.isEmpty(items)) {
            return "\u6821\u9a8c\u5f02\u5e38\uff0c\u5546\u54c1\u5217\u8868\u4e3a\u7a7a";
        }
        StringBuilder msg = new StringBuilder("");
        for (InventoryCheckItem item : items) {
            String format;
            String batchMsg;
            if (item.isCheckResult()) continue;
            if (StringUtils.isNotBlank((CharSequence)item.getBatch())) {
                batchMsg = "\u4ed3\u5e93 %s, \u54c1 %s,\u6279\u6b21 %s, \u603b\u5e93\u5b58 %s, \u9700\u8981\u5e93\u5b58 %s, \u5e93\u5b58\u4e0d\u8db3\uff1b";
                format = String.format(batchMsg, item.getLogicWarehouseCode(), item.getLongCode(), item.getBatch(), item.getCurInventory(), item.getTargetInventory());
                msg.append(format);
                continue;
            }
            batchMsg = "\u4ed3\u5e93 %s, \u54c1 %s, \u603b\u5e93\u5b58 %s, \u9700\u8981\u5e93\u5b58 %s, \u5e93\u5b58\u4e0d\u8db3\uff1b";
            format = String.format(batchMsg, item.getLogicWarehouseCode(), item.getLongCode(), item.getCurInventory(), item.getTargetInventory());
            msg.append(format);
        }
        return msg.toString();
    }

    private Map<String, PcpItemRespDto> queryItemInfo(List<String> longCodes) {
        try {
            logger.info("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(longCodes));
            if (CollectionUtils.isEmpty(longCodes)) {
                return new HashMap<String, PcpItemRespDto>();
            }
            List itemList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                return itemList.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, entity -> entity));
            }
            return new HashMap<String, PcpItemRespDto>();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

