/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CsDeliveryNoticeOrderQueryApiImpl
implements ICsDeliveryNoticeOrderQueryApi {
    private static final Logger log = LoggerFactory.getLogger(CsDeliveryNoticeOrderQueryApiImpl.class);
    @Autowired
    protected ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    protected IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    protected IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    protected IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    protected IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    protected IInOutResultOrderDomain inOutResultOrderDomain;

    public RestResponse<CsDeliveryNoticeOrderRespDto> queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsDeliveryNoticeOrderRespDto csDeliveryNoticeOrderRespDto = this.csDeliveryNoticeOrderQueryService.queryById(id);
        AssertUtil.isTrue(csDeliveryNoticeOrderRespDto != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        csDeliveryNoticeOrderRespDto.setTotalQuantity(String.valueOf(BigInteger.ZERO));
        csDeliveryNoticeOrderRespDto.setSkuNum(String.valueOf(BigInteger.ZERO));
        csDeliveryNoticeOrderRespDto.setTotalCartons(BigDecimal.ZERO);
        csDeliveryNoticeOrderRespDto.setMergeQuantity(String.valueOf(BigInteger.ZERO));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"document_no", new Object[]{csDeliveryNoticeOrderRespDto.getDocumentNo()});
        List ReceiveDeliveryNoticeOrderDetailEos = this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)wrapper);
        log.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)ReceiveDeliveryNoticeOrderDetailEos));
        ArrayList csDeliveryNoticeOrderDetailRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyProperties((Object)csDeliveryNoticeOrderDetailRespDtos, (Object)ReceiveDeliveryNoticeOrderDetailEos, (String[])new String[0]);
        DtoHelper.eoList2DtoList((Collection)ReceiveDeliveryNoticeOrderDetailEos, (Collection)csDeliveryNoticeOrderDetailRespDtos, CsDeliveryNoticeOrderDetailRespDto.class);
        log.info("copy\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)csDeliveryNoticeOrderDetailRespDtos));
        csDeliveryNoticeOrderRespDto.setDeliveryNoticeOrderDetailRespDtoList((List)csDeliveryNoticeOrderDetailRespDtos);
        HashSet<String> skuSet = new HashSet<String>();
        BigDecimal totalSkuDecimal = BigDecimal.ZERO;
        for (CsDeliveryNoticeOrderDetailRespDto detailRespDto : csDeliveryNoticeOrderDetailRespDtos) {
            skuSet.add(detailRespDto.getLongCode());
            totalSkuDecimal = totalSkuDecimal.add(detailRespDto.getPlanQuantity());
        }
        log.info("set\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(skuSet));
        csDeliveryNoticeOrderRespDto.setSkuNum(String.valueOf(skuSet.size()));
        csDeliveryNoticeOrderRespDto.setTotalQuantity(String.valueOf(totalSkuDecimal));
        InOutNoticeOrderEo InOutNoticeOrderEo2 = new InOutNoticeOrderEo();
        InOutNoticeOrderEo2.setRelevanceNo(csDeliveryNoticeOrderRespDto.getDocumentNo());
        InOutNoticeOrderEo2 = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.selectOne((BaseEo)InOutNoticeOrderEo2);
        if (Objects.nonNull(InOutNoticeOrderEo2)) {
            InOutResultOrderEo inOutResultOrderEo = new InOutResultOrderEo();
            inOutResultOrderEo.setRelevanceNo(InOutNoticeOrderEo2.getDocumentNo());
            List inOutResultOrderEos = this.inOutResultOrderDomain.selectList((BaseEo)inOutResultOrderEo);
            if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderEos)) {
                List csOutResultOrderDocuNos = inOutResultOrderEos.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
                QueryWrapper resultWrapper = new QueryWrapper();
                resultWrapper.in((Object)"relevance_no", csOutResultOrderDocuNos);
                List csDeliveryResultOrderEos = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)resultWrapper);
                log.info("\u53d1\u8d27\u5355\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)csDeliveryResultOrderEos));
                if (CollectionUtils.isNotEmpty((Collection)csDeliveryResultOrderEos)) {
                    ArrayList csDeliveryResultOrderRespDtos = Lists.newArrayList();
                    DtoHelper.eoList2DtoList((Collection)csDeliveryResultOrderEos, (Collection)csDeliveryResultOrderRespDtos, CsDeliveryResultOrderRespDto.class);
                    csDeliveryNoticeOrderRespDto.setDeliveryResultList((List)csDeliveryResultOrderRespDtos);
                    BigDecimal[] totalQuantityDecimal = new BigDecimal[]{BigDecimal.ZERO};
                    csDeliveryResultOrderEos.stream().forEach(dto -> {
                        totalQuantityDecimal[0] = totalQuantityDecimal[0].add(dto.getTotalQuantity());
                    });
                    log.info("\u53d1\u8d27\u5355\u7ed3\u679c\u603b\u7bb1\u6570\uff1a{}", (Object)totalQuantityDecimal[0]);
                    csDeliveryNoticeOrderRespDto.setTotalQuantity(String.valueOf(totalQuantityDecimal[0]));
                    BigDecimal[] totalMergeQuantityDecimal = new BigDecimal[]{BigDecimal.ZERO};
                    csDeliveryResultOrderEos.stream().forEach(dto -> {
                        totalMergeQuantityDecimal[0] = totalMergeQuantityDecimal[0].add(dto.getMergeQuantity());
                    });
                    log.info("\u53d1\u8d27\u7ed3\u679c\u5355\u62fc\u7bb1\u6570\uff1a{}", (Object)totalMergeQuantityDecimal[0]);
                    csDeliveryNoticeOrderRespDto.setMergeQuantity(String.valueOf(totalMergeQuantityDecimal[0]));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)csDeliveryNoticeOrderRespDto.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)csDeliveryNoticeOrderRespDto.getExtension(), ContactDto.class);
                csDeliveryNoticeOrderRespDto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                log.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        return new RestResponse((Object)csDeliveryNoticeOrderRespDto);
    }

    public RestResponse<CsDeliveryNoticeOrderRespDto> queryByDocumentNo(String documentNo) {
        return new RestResponse((Object)this.csDeliveryNoticeOrderQueryService.queryByDocumentNo(documentNo));
    }

    public RestResponse<CsDeliveryNoticeOrderRespDto> queryVersionSecondByDocumentNo(String documentNo) {
        return new RestResponse((Object)this.csDeliveryNoticeOrderQueryService.queryVersionSecondByDocumentNo(documentNo));
    }

    public RestResponse<PageInfo<CsDeliveryNoticeOrderDetailRespDto>> queryDeliveryNoticeOrderDetails(CsDeliveryNoticeOrderDetailQueryDto dto) {
        return new RestResponse(this.csDeliveryNoticeOrderQueryService.queryDeliveryNoticeOrderDetails(dto));
    }

    public RestResponse<PageInfo<CsDeliveryNoticeOrderRespDto>> queryByPage(CsDeliveryNoticeOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        PageInfo<CsDeliveryNoticeOrderRespDto> pageInfo = this.csDeliveryNoticeOrderQueryService.queryByPage(queryDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<List<CsDeliveryNoticeOrderRespDto>> queryByParam(CsDeliveryNoticeOrderQueryDto queryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        return new RestResponse(null);
    }

    public RestResponse<List<String>> queryPreOrderNoIsBatch(List<String> preOrderNoList) {
        log.info("\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u5173\u8054\u7684\u53d1\u8d27\u901a\u77e5\u5355\uff0c\u6ca1\u6709\u8bbe\u7f6e\u6279\u6b21\u7684\u524d\u7f6e\u5355\u636e\u53f7\uff08\u8ba2\u5355\u53f7\uff09 \u5165\u53c2\uff1a[{}]", (Object)LogUtils.buildLogContent(preOrderNoList));
        List<String> list = this.csDeliveryNoticeOrderQueryService.queryPreOrderNoIsBatch(preOrderNoList);
        return new RestResponse(list);
    }

    public RestResponse<CsDeliveryNoticeOrderRespDto> queryByRelevanceNo(String relevanceNo) {
        return null;
    }
}

