/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsQualityInfoDetailService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsQualityInfoDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsStorageAuditRecordDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsQualityInfoDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsQualityInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsStorageAuditRecordEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.QualityReleaseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.QualityStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.ReportResultTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsDeliveryNumDetailsQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsQualityInfoDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsQualityInfoDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsReleaseQualityInfoDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsDeliveryNumDetailsRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsQualityInfoDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsQueryWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsWarehouseDetailsRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsQualityInfoDetailServiceImpl
implements ICsQualityInfoDetailService {
    private static final Logger logger = LoggerFactory.getLogger(CsQualityInfoDetailServiceImpl.class);
    @Resource
    private CsQualityInfoDetailDas csQualityInfoDetailDas;
    @Resource
    IRelWarehouseDomain relWarehouseDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ICsTransferOrderService transferOrderService;
    @Resource
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private CsStorageAuditRecordDas csStorageAuditRecordDas;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    BaseOrderFacade baseOrderFacade;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCsQualityInfoDetail(CsQualityInfoDetailReqDto addReqDto) {
        CsQualityInfoDetailEo csQualityInfoDetailEo = new CsQualityInfoDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csQualityInfoDetailEo);
        this.csQualityInfoDetailDas.insert((BaseEo)csQualityInfoDetailEo);
        return csQualityInfoDetailEo.getId();
    }

    @Override
    public void batchAddQualityDetail(List<CsQualityInfoDetailReqDto> csQualityInfoDetailReqDtoList) {
        logger.info("batchAddQualityDetail\u6279\u91cf\u65b0\u589e\u5f85\u68c0\u8f6c\u5408\u683c\u5355\u636e:{}", (Object)LogUtils.buildLogContent(csQualityInfoDetailReqDtoList));
        ArrayList csQualityInfoDetailEo = new ArrayList();
        DtoHelper.dtoList2EoList(csQualityInfoDetailReqDtoList, csQualityInfoDetailEo, CsQualityInfoDetailEo.class);
        this.csQualityInfoDetailDas.insertBatch(csQualityInfoDetailEo);
    }

    @Override
    public void modifyCsQualityInfoDetail(CsQualityInfoDetailReqDto modifyReqDto) {
        CsQualityInfoDetailEo csQualityInfoDetailEo = new CsQualityInfoDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csQualityInfoDetailEo);
        this.csQualityInfoDetailDas.updateSelective((BaseEo)csQualityInfoDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsQualityInfoDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csQualityInfoDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void releaseQualityInfoDetail(CsReleaseQualityInfoDetailReqDto releaseQualityInfoDetailReqDto) {
        logger.info("releaseQualityInfoDetail\u5f85\u68c0\u8f6c\u5408\u683c\u653e\u884c:{}", (Object)LogUtils.buildLogContent(releaseQualityInfoDetailReqDto));
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)releaseQualityInfoDetailReqDto.getPlannedOrderNo()), "\u8ba1\u5212\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        CsQualityInfoDetailEo detailEo = (CsQualityInfoDetailEo)((ExtQueryChainWrapper)this.csQualityInfoDetailDas.filter().eq((Object)"planned_order_no", (Object)releaseQualityInfoDetailReqDto.getPlannedOrderNo())).one();
        if (ReportResultTypeEnum.YES.getCode().equals(detailEo.getReceiveReportFlag())) {
            if (QualityStatusEnum.QUALIFIED.getCode().equals(detailEo.getReportResult())) {
                this.qualifiedTreatment(detailEo);
            } else {
                this.unQualifiedTreatment(releaseQualityInfoDetailReqDto, detailEo);
            }
        } else {
            logger.info("\u6682\u672a\u6536\u5230\u8d28\u68c0\u62a5\u544a:{}", (Object)LogUtils.buildLogContent(detailEo));
            CsQualityInfoDetailEo csQualityInfoDetailEo = new CsQualityInfoDetailEo();
            csQualityInfoDetailEo.setId(detailEo.getId());
            csQualityInfoDetailEo.setDischargedStatus(QualityReleaseStatusEnum.PASSED.getCode());
            this.csQualityInfoDetailDas.updateSelective((BaseEo)csQualityInfoDetailEo);
        }
    }

    @Override
    public void batchRelease(List<CsReleaseQualityInfoDetailReqDto> releaseQualityInfoDetailReqDtoList) {
        logger.info("batchRelease\u5f85\u68c0\u8f6c\u5408\u683c\u6279\u91cf\u653e\u884c:{}", (Object)LogUtils.buildLogContent(releaseQualityInfoDetailReqDtoList));
        List plannedOrderNoList = releaseQualityInfoDetailReqDtoList.stream().map(CsReleaseQualityInfoDetailReqDto::getPlannedOrderNo).collect(Collectors.toList());
        Map map = releaseQualityInfoDetailReqDtoList.stream().collect(Collectors.toMap(CsReleaseQualityInfoDetailReqDto::getPlannedOrderNo, Function.identity()));
        List detailEoList = ((ExtQueryChainWrapper)this.csQualityInfoDetailDas.filter().in((Object)"planned_order_no", plannedOrderNoList)).list();
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            List disqualification = detailEoList.stream().filter(detailEo -> QualityStatusEnum.DISQUALIFICATION.getCode().equals(detailEo.getReportResult())).collect(Collectors.toList());
            AssertUtil.isTrue(CollectionUtils.isEmpty(disqualification), "\u4e0d\u5408\u683c\u5f85\u68c0\u8f6c\u5408\u683c\u5355\u636e\u65e0\u6cd5\u6279\u91cf\u653e\u884c\uff01");
            detailEoList.forEach(detailEo -> {
                if (ReportResultTypeEnum.YES.getCode().equals(detailEo.getReceiveReportFlag())) {
                    this.qualifiedTreatment((CsQualityInfoDetailEo)detailEo);
                } else {
                    logger.info("\u6682\u672a\u6536\u5230\u8d28\u68c0\u62a5\u544a:{}", (Object)LogUtils.buildLogContent(detailEo));
                    CsQualityInfoDetailEo csQualityInfoDetailEo = new CsQualityInfoDetailEo();
                    csQualityInfoDetailEo.setId(detailEo.getId());
                    csQualityInfoDetailEo.setDischargedStatus(QualityReleaseStatusEnum.PASSED.getCode());
                    this.csQualityInfoDetailDas.updateSelective((BaseEo)csQualityInfoDetailEo);
                }
            });
        }
    }

    @Override
    public CsQualityInfoDetailRespDto queryById(Long id) {
        CsQualityInfoDetailEo csQualityInfoDetailEo = (CsQualityInfoDetailEo)this.csQualityInfoDetailDas.selectByPrimaryKey(id);
        CsQualityInfoDetailRespDto csQualityInfoDetailRespDto = new CsQualityInfoDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)csQualityInfoDetailEo, (BaseVo)csQualityInfoDetailRespDto);
        return csQualityInfoDetailRespDto;
    }

    @Override
    public PageInfo<CsQualityInfoDetailRespDto> queryByPage(CsQualityInfoDetailQueryDto qualityInfoDetailQueryDto) {
        logger.info("\u83b7\u53d6\u8d28\u68c0\u5217\u8868-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)qualityInfoDetailQueryDto));
        Integer pageNum = qualityInfoDetailQueryDto.getPageNum();
        Integer pageSize = qualityInfoDetailQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper<CsQualityInfoDetailEo> param = this.assembleCondition(qualityInfoDetailQueryDto);
        PageInfo page = param.select(new String[0]).page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)page.getList(), dtoList, CsQualityInfoDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void qualityInfoAdd(List<CsQualityInfoEo> csQualityInfoEos) {
        logger.info("\u66f4\u65b0\u8d28\u68c0\u7ed3\u679c:{}", (Object)JSON.toJSONString(csQualityInfoEos));
        List externalNoList = csQualityInfoEos.stream().map(CsQualityInfoEo::getExternalNo).collect(Collectors.toList());
        Map map = csQualityInfoEos.stream().collect(Collectors.toMap(x -> x.getExternalNo() + x.getLongCode() + x.getBatch(), Function.identity()));
        List detailList = ((ExtQueryChainWrapper)this.csQualityInfoDetailDas.filter().in((Object)"platform_order_no", externalNoList)).list();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(detail -> {
                String key = detail.getPlannedOrderNo() + detail.getLongCode() + detail.getBatch();
                if (map.containsKey(key)) {
                    CsQualityInfoEo csQualityInfoEo = (CsQualityInfoEo)map.get(key);
                    detail.setReportTime(csQualityInfoEo.getReportTime());
                    detail.setReportResult(QualityStatusEnum.QUALIFIED.getDesc().equals(csQualityInfoEo.getReportResult()) ? QualityStatusEnum.QUALIFIED.getCode() : QualityStatusEnum.DISQUALIFICATION.getCode());
                    detail.setReportResultUrl(csQualityInfoEo.getReportResultUrl());
                    detail.setReceiveReportFlag(ReportResultTypeEnum.NO.getCode());
                    this.csQualityInfoDetailDas.updateSelective((BaseEo)detail);
                }
            });
        } else {
            logger.info("\u8d28\u68c0\u62a5\u544a\u672a\u627e\u5230\u76f8\u5173\u5355\u636e");
        }
    }

    @Override
    public PageInfo<CsDeliveryNumDetailsRespDto> getDeliveryNumDetails(CsDeliveryNumDetailsQueryDto deliveryNumDetailsQueryDto) {
        logger.info("\u83b7\u53d6\u5df2\u51fa\u5e93\u6570\u91cf\u8be6\u60c5-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)deliveryNumDetailsQueryDto));
        Integer pageNum = deliveryNumDetailsQueryDto.getPageNum();
        Integer pageSize = deliveryNumDetailsQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)deliveryNumDetailsQueryDto.getOrderNo()), "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        CsQualityInfoDetailEo orderDetailEo = (CsQualityInfoDetailEo)((ExtQueryChainWrapper)this.csQualityInfoDetailDas.filter().eq((Object)"planned_order_no", (Object)deliveryNumDetailsQueryDto.getOrderNo())).one();
        AssertUtil.isTrue(null != orderDetailEo, "\u672a\u67e5\u5230\u8be5\u5f85\u68c0\u8f6c\u5408\u683c\u5355\u636e");
        List outResultOrderDetailList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"sku_code", (Object)orderDetailEo.getLongCode())).eq((Object)"batch", (Object)orderDetailEo.getBatch())).list();
        if (CollectionUtils.isEmpty((Collection)outResultOrderDetailList)) {
            return new PageInfo();
        }
        List documentNoList = outResultOrderDetailList.stream().map(InOutResultOrderDetailEo::getDocumentNo).distinct().collect(Collectors.toList());
        Map map = outResultOrderDetailList.stream().collect(Collectors.toMap(InOutResultOrderDetailEo::getDocumentNo, Function.identity()));
        List outResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().in((Object)"document_no", documentNoList)).eq((Object)"out_logic_warehouse_code", (Object)orderDetailEo.getWarehouseCode())).eq((Object)"order_type", (Object)"out")).list();
        if (CollectionUtils.isEmpty((Collection)outResultOrderEoList)) {
            return new PageInfo();
        }
        List<InOutResultOrderEo> deliveryInfo = outResultOrderEoList.stream().filter(x -> !CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode().equals(x.getBusinessType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(deliveryInfo)) {
            return new PageInfo();
        }
        PageInfo selectPage = new PageInfo(deliveryInfo);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        deliveryInfo.forEach(order -> {
            CsDeliveryNumDetailsRespDto csDeliveryNumDetailsRespDto = new CsDeliveryNumDetailsRespDto();
            csDeliveryNumDetailsRespDto.setOrderNo(order.getDocumentNo());
            csDeliveryNumDetailsRespDto.setDoneQuantity(((InOutResultOrderDetailEo)map.get(order.getDocumentNo())).getDocumentNo());
            csDeliveryNumDetailsRespDto.setRemark(order.getRemark());
            dtoList.add(csDeliveryNumDetailsRespDto);
        });
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public PageInfo<CsWarehouseDetailsRespDto> getWarehouse(CsDeliveryNumDetailsQueryDto deliveryNumDetailsQueryDto) {
        logger.info("\u83b7\u53d6\u4ed3\u5e93\u8be6\u60c5-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)deliveryNumDetailsQueryDto));
        Integer pageNum = deliveryNumDetailsQueryDto.getPageNum();
        Integer pageSize = deliveryNumDetailsQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)deliveryNumDetailsQueryDto.getOrderNo()), "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        CsQualityInfoDetailEo orderDetailEo = (CsQualityInfoDetailEo)((ExtQueryChainWrapper)this.csQualityInfoDetailDas.filter().eq((Object)"planned_order_no", (Object)deliveryNumDetailsQueryDto.getOrderNo())).one();
        AssertUtil.isTrue(null != orderDetailEo, "\u672a\u67e5\u5230\u8be5\u5f85\u68c0\u8f6c\u5408\u683c\u5355\u636e");
        List outResultOrderDetailList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"sku_code", (Object)orderDetailEo.getLongCode())).eq((Object)"batch", (Object)orderDetailEo.getBatch())).list();
        if (CollectionUtils.isEmpty((Collection)outResultOrderDetailList)) {
            return new PageInfo();
        }
        List documentNoList = outResultOrderDetailList.stream().map(InOutResultOrderDetailEo::getDocumentNo).distinct().collect(Collectors.toList());
        List outResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().in((Object)"document_no", documentNoList)).eq((Object)"out_logic_warehouse_code", (Object)orderDetailEo.getWarehouseCode())).eq((Object)"order_type", (Object)"out")).list();
        if (CollectionUtils.isEmpty((Collection)outResultOrderEoList)) {
            return new PageInfo();
        }
        List deliveryInfo = outResultOrderEoList.stream().filter(x -> !CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode().equals(x.getBusinessType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(deliveryInfo)) {
            return new PageInfo();
        }
        PageInfo selectPage = new PageInfo(deliveryInfo);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        List<String> warehouse = deliveryInfo.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getOutPhysicsWarehouseName())).map(InOutResultOrderEo::getOutPhysicsWarehouseName).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(warehouse)) {
            warehouse.forEach(warehouseName -> {
                CsWarehouseDetailsRespDto csWarehouseDetailsRespDto = new CsWarehouseDetailsRespDto();
                csWarehouseDetailsRespDto.setWarehouse(warehouseName);
                dtoList.add(csWarehouseDetailsRespDto);
            });
        }
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public List<CsQueryWarehouseRespDto> queryReleaseWarehouse(String orderNo) {
        logger.info("\u83b7\u53d6\u4e0d\u5408\u683c\u653e\u884c\u4ed3\u5e93\u96c6\u5408-\u8f93\u5165:{}", (Object)orderNo);
        CsQualityInfoDetailEo orderDetailEo = (CsQualityInfoDetailEo)((ExtQueryChainWrapper)this.csQualityInfoDetailDas.filter().eq((Object)"planned_order_no", (Object)orderNo)).one();
        AssertUtil.isTrue(null != orderDetailEo, "\u672a\u67e5\u5230\u8be5\u5f85\u68c0\u8f6c\u5408\u683c\u5355\u636e");
        LogicWarehouseEo outWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)orderDetailEo.getWarehouseCode())).one();
        RelWarehouseEo physicsEo = (RelWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)orderDetailEo.getWarehouseCode())).eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).one();
        logger.info("queryReleaseWarehouse==>physicsEo:{}", (Object)LogUtils.buildLogContent(physicsEo));
        AssertUtil.isTrue(null != physicsEo, "\u6839\u636e\u5f85\u68c0\u903b\u8f91\u4ed3\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3");
        List logicEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)physicsEo.getRefWarehouseCode())).eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).list();
        logger.info("qualifiedTreatment==>logicEoList:{}", (Object)LogUtils.buildLogContent(logicEoList));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicEoList), "\u6839\u636e\u7269\u7406\u4ed3\u5e93\u672a\u67e5\u5230\u5173\u8054\u7684\u903b\u8f91\u4ed3\u5e93");
        List logicCodeList = logicEoList.stream().map(RelWarehouseEo::getRefWarehouseCode).distinct().collect(Collectors.toList());
        ArrayList<String> warehouseQuality = new ArrayList<String>();
        warehouseQuality.add(CsLogicWarehouseQualityEnum.UN_QUALIFIED.getCode());
        warehouseQuality.add(CsLogicWarehouseQualityEnum.PENDING.getCode());
        List logicWarehouseList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", logicCodeList)).in((Object)"warehouse_quality", warehouseQuality)).eq((Object)"organization_id", (Object)outWarehouse.getOrganizationId())).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseList), "\u6839\u636e\u7269\u7406\u4ed3\u5e93\u672a\u67e5\u5230\u5173\u8054\u7684\u903b\u8f91\u4e0d\u5408\u683c\u4ed3\u5e93\u548c\u5f85\u5904\u7406\u4ed3\u5e93");
        ArrayList<CsQueryWarehouseRespDto> queryWarehouseRespDtoList = new ArrayList<CsQueryWarehouseRespDto>();
        logicWarehouseList.forEach(warehouse -> {
            CsQueryWarehouseRespDto queryWarehouseRespDto = new CsQueryWarehouseRespDto();
            queryWarehouseRespDto.setWarehouseId(warehouse.getId().longValue());
            queryWarehouseRespDto.setWarehouseName(warehouse.getWarehouseName());
            queryWarehouseRespDto.setWarehouseCode(warehouse.getWarehouseCode());
            queryWarehouseRespDtoList.add(queryWarehouseRespDto);
        });
        return queryWarehouseRespDtoList;
    }

    public ExtQueryChainWrapper<CsQualityInfoDetailEo> assembleCondition(CsQualityInfoDetailQueryDto qualityInfoDetailQueryDto) {
        ExtQueryChainWrapper filter = this.csQualityInfoDetailDas.filter();
        if (StringUtils.isNotBlank((CharSequence)qualityInfoDetailQueryDto.getPlannedOrderNo())) {
            filter.like((Object)"planned_order_no", (Object)qualityInfoDetailQueryDto.getPlannedOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)qualityInfoDetailQueryDto.getBatch())) {
            filter.like((Object)"batch", (Object)qualityInfoDetailQueryDto.getBatch());
        }
        if (StringUtils.isNotBlank((CharSequence)qualityInfoDetailQueryDto.getLongCode())) {
            filter.like((Object)"sku_code", (Object)qualityInfoDetailQueryDto.getLongCode());
        }
        if (StringUtils.isNotBlank((CharSequence)qualityInfoDetailQueryDto.getCargoName())) {
            filter.like((Object)"sku_name", (Object)qualityInfoDetailQueryDto.getCargoName());
        }
        if (StringUtils.isNotBlank((CharSequence)qualityInfoDetailQueryDto.getPushWmsStatus())) {
            filter.eq((Object)"push_wms_status", (Object)qualityInfoDetailQueryDto.getPushWmsStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)qualityInfoDetailQueryDto.getBeginTime())) {
            filter.ge((Object)"report_time", (Object)qualityInfoDetailQueryDto.getBeginTime());
        }
        if (StringUtils.isNotBlank((CharSequence)qualityInfoDetailQueryDto.getEndTime())) {
            filter.le((Object)"report_time", (Object)qualityInfoDetailQueryDto.getEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)qualityInfoDetailQueryDto.getRemark())) {
            filter.like((Object)"remark", (Object)qualityInfoDetailQueryDto.getRemark());
        }
        ((ExtQueryChainWrapper)filter.orderByDesc((Object)qualityInfoDetailQueryDto.getOrderByDesc())).orderByDesc((Object)"id");
        return filter;
    }

    public void qualifiedTreatment(CsQualityInfoDetailEo detailEo) {
        logger.info("qualifiedTreatment\u5f85\u68c0\u8f6c\u5408\u683c\u653e\u884c:{}", (Object)LogUtils.buildLogContent(detailEo));
        LogicWarehouseEo outWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)detailEo.getWarehouseCode())).one();
        RelWarehouseEo physicsEo = (RelWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)detailEo.getWarehouseCode())).eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).one();
        logger.info("qualifiedTreatment==>physicsEo:{}", (Object)LogUtils.buildLogContent(physicsEo));
        AssertUtil.isTrue(null != physicsEo, "\u6839\u636e\u5f85\u68c0\u903b\u8f91\u4ed3\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3");
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)physicsEo.getRefWarehouseCode())).one();
        List logicEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)physicsEo.getRefWarehouseCode())).eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).list();
        logger.info("qualifiedTreatment==>logicEoList:{}", (Object)LogUtils.buildLogContent(logicEoList));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicEoList), "\u6839\u636e\u7269\u7406\u4ed3\u5e93\u672a\u67e5\u5230\u5173\u8054\u7684\u903b\u8f91\u4ed3\u5e93");
        List logicCodeList = logicEoList.stream().map(RelWarehouseEo::getRefWarehouseCode).distinct().collect(Collectors.toList());
        List logicWarehouseList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", logicCodeList)).eq((Object)"warehouse_quality", (Object)CsLogicWarehouseQualityEnum.QUALIFIED.getCode())).eq((Object)"organization_id", (Object)outWarehouse.getOrganizationId())).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseList), "\u6839\u636e\u7269\u7406\u4ed3\u5e93\u672a\u67e5\u5230\u5173\u8054\u7684\u5408\u683c\u903b\u8f91\u4ed3\u5e93");
        LogicWarehouseEo inWarehouse = (LogicWarehouseEo)logicWarehouseList.get(0);
        String transferNo = this.generateTransferOrder(outWarehouse, inWarehouse, physicsWarehouseEo, detailEo);
        this.updateOrderDetail(detailEo, inWarehouse, transferNo);
    }

    public void unQualifiedTreatment(CsReleaseQualityInfoDetailReqDto releaseQualityInfoDetailReqDto, CsQualityInfoDetailEo detailEo) {
        logger.info("unQualifiedTreatment\u5f85\u68c0\u8f6c\u4e0d\u5408\u683c\u653e\u884c:{}", (Object)LogUtils.buildLogContent(detailEo));
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)releaseQualityInfoDetailReqDto.getReleaseWarehouseCode()), "\u9009\u62e9\u653e\u884c\u7684\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo outWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)detailEo.getWarehouseCode())).one();
        RelWarehouseEo physicsEo = (RelWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)detailEo.getWarehouseCode())).eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).one();
        logger.info("qualifiedTreatment==>physicsEo:{}", (Object)LogUtils.buildLogContent(physicsEo));
        AssertUtil.isTrue(null != physicsEo, "\u6839\u636e\u5f85\u68c0\u903b\u8f91\u4ed3\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3");
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)physicsEo.getRefWarehouseCode())).one();
        LogicWarehouseEo inWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", new Object[]{releaseQualityInfoDetailReqDto.getReleaseWarehouseCode()})).one();
        String transferNo = this.generateTransferOrder(outWarehouse, inWarehouse, physicsWarehouseEo, detailEo);
        this.updateOrderDetail(detailEo, inWarehouse, transferNo);
    }

    public String generateTransferOrder(LogicWarehouseEo outWarehouse, LogicWarehouseEo inWarehouse, PhysicsWarehouseEo physicsWarehouseEo, CsQualityInfoDetailEo detailEo) {
        CsTransferOrderComboReqDto transferOrderComboReqDto = new CsTransferOrderComboReqDto();
        String transferNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.PCP_TRANSFER_ORDER.getCode()).getCode();
        CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
        transferOrderReqDto.setPreOrderNo(detailEo.getPlannedOrderNo());
        transferOrderReqDto.setTransferOrderNo(transferNo);
        transferOrderReqDto.setOrderStatus(CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode());
        transferOrderReqDto.setOrderSrc("PCP");
        transferOrderReqDto.setInLogicWarehouseCode(inWarehouse.getWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(inWarehouse.getWarehouseName());
        transferOrderReqDto.setInPhysicsWarehouseCode(physicsWarehouseEo.getWarehouseCode());
        transferOrderReqDto.setInPhysicsWarehouseName(physicsWarehouseEo.getWarehouseName());
        transferOrderReqDto.setInOrganization(inWarehouse.getOrganizationName());
        transferOrderReqDto.setInOrganizationId(inWarehouse.getOrganizationId());
        transferOrderReqDto.setOutLogicWarehouseCode(outWarehouse.getWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(outWarehouse.getWarehouseName());
        transferOrderReqDto.setOutPhysicsWarehouseCode(physicsWarehouseEo.getWarehouseCode());
        transferOrderReqDto.setOutPhysicsWarehouseName(physicsWarehouseEo.getWarehouseName());
        transferOrderReqDto.setOutOrganization(outWarehouse.getOrganizationCode());
        transferOrderReqDto.setOutOrganizationId(outWarehouse.getOrganizationId());
        transferOrderReqDto.setTotalQuantity(detailEo.getQuantity());
        transferOrderReqDto.setType(CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode());
        transferOrderComboReqDto.setCsOtherStorageOrderReqDto(transferOrderReqDto);
        ArrayList<CsTransferOrderDetailReqDto> detailList = new ArrayList<CsTransferOrderDetailReqDto>();
        CsTransferOrderDetailReqDto csTransferOrderDetailReqDto = new CsTransferOrderDetailReqDto();
        csTransferOrderDetailReqDto.setCargoId(detailEo.getCargoId());
        csTransferOrderDetailReqDto.setCargoName(detailEo.getCargoName());
        csTransferOrderDetailReqDto.setCargoCode(detailEo.getCargoCode());
        csTransferOrderDetailReqDto.setBatch(detailEo.getBatch());
        csTransferOrderDetailReqDto.setArtNo(detailEo.getArtNo());
        csTransferOrderDetailReqDto.setLongCode(detailEo.getLongCode());
        csTransferOrderDetailReqDto.setDueDate(DateUtils.formatDate(detailEo.getExpireTime(), "yyyy-MM-dd HH:mm:ss"));
        csTransferOrderDetailReqDto.setProductDate(DateUtils.formatDate(detailEo.getProduceTime(), "yyyy-MM-dd HH:mm:ss"));
        csTransferOrderDetailReqDto.setQuantity(detailEo.getQuantity().subtract(detailEo.getDoneQuantity()));
        detailList.add(csTransferOrderDetailReqDto);
        transferOrderComboReqDto.setDetailList(detailList);
        this.transferOrderService.addTransferOrder(transferOrderComboReqDto);
        this.insertAuditLog(transferNo);
        this.generateDeliveryNoticeOrder(transferOrderReqDto, detailList);
        return transferNo;
    }

    public void updateOrderDetail(CsQualityInfoDetailEo detailEo, LogicWarehouseEo inWarehouse, String transferNo) {
        CsQualityInfoDetailEo csQualityInfoDetailEo = new CsQualityInfoDetailEo();
        csQualityInfoDetailEo.setId(detailEo.getId());
        csQualityInfoDetailEo.setReleaseWarehouseCode(inWarehouse.getWarehouseCode());
        csQualityInfoDetailEo.setReleaseWarehouseId(inWarehouse.getId());
        csQualityInfoDetailEo.setReleaseWarehouseName(inWarehouse.getWarehouseName());
        csQualityInfoDetailEo.setTransferOrderNo(transferNo);
        csQualityInfoDetailEo.setDischargedStatus(QualityReleaseStatusEnum.PASSED.getCode());
        this.csQualityInfoDetailDas.updateSelective((BaseEo)csQualityInfoDetailEo);
    }

    private void insertAuditLog(String plannedOrderNo) {
        CsStorageAuditRecordEo auditLog = new CsStorageAuditRecordEo();
        auditLog.setAuditResult(CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode());
        auditLog.setRemark("\u5f85\u68c0\u8f6c\u5408\u683c\u5355\u636e\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        auditLog.setType(CsOtherStorageOrderEnum.InOrOut.INSPECTION_QUALIFIED.getCode());
        auditLog.setOrderSrcNo(plannedOrderNo);
        this.csStorageAuditRecordDas.insert((BaseEo)auditLog);
    }

    private void generateDeliveryNoticeOrder(CsTransferOrderReqDto respDto, List<CsTransferOrderDetailReqDto> detailList) {
        logger.info("generateDeliveryNoticeOrder==>\u8c03\u62e8\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)respDto.getTransferOrderNo());
        ReceiveDeliveryNoticeOrderFacadeBo noticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        noticeOrderFacadeBo.setPreOrderNo(respDto.getPreOrderNo());
        noticeOrderFacadeBo.setExternalOrderNo("");
        noticeOrderFacadeBo.setRelevanceNo(respDto.getTransferOrderNo());
        noticeOrderFacadeBo.setBusinessType(respDto.getType());
        noticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        noticeOrderFacadeBo.setLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
        noticeOrderFacadeBo.setLogicWarehouseName(respDto.getOutLogicWarehouseName());
        noticeOrderFacadeBo.setPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
        noticeOrderFacadeBo.setPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
        noticeOrderFacadeBo.setTransferInLogicWarehouseCode(respDto.getInLogicWarehouseCode());
        noticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT.getCode());
        noticeOrderFacadeBo.setPreemptReleaseType(CsInventorySourceTypeEnum.TRANSFER_OTHER_PREEMPT.getCode());
        ArrayList<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(detailList.size());
        for (CsTransferOrderDetailReqDto detail : detailList) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            basic.setPreOrderItemId(detail.getId());
            basic.setSkuCode(detail.getLongCode());
            basic.setSkuName(detail.getCargoName());
            basic.setQuantity(detail.getQuantity());
            basic.setBatch(detail.getBatch());
            basic.setVolume(detail.getVolume());
            deliveryDetailList.add(basic);
        }
        noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        noticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        this.baseOrderFacade.deliveryNoticeOrderGen(noticeOrderFacadeBo);
    }
}

