/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsOtherStorageOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsBusinessTypeDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsOtherStorageOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsOtherStorageOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsBusinessTypeEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsOtherStorageOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsOtherStorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBatchItemQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsCallBackItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderEditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageOrderCallBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBatchItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRelevanceOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOtherStorageOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessTypeStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdTypeOfDocumentEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicInventoryBusinessTypeEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsOtherStorageOrderServiceImpl
implements ICsOtherStorageOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsOtherStorageOrderServiceImpl.class);
    @Resource
    CsOtherStorageOrderDas csOtherStorageOrderDas;
    @Resource
    CsOtherStorageOrderDetailDas csOtherStorageOrderDetailDas;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private CsBusinessTypeDas csBusinessTypeDas;
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String storageOrderCallBack(CsStorageOrderCallBackReqDto csStorageOrderCallBackReqDto) {
        this.checkParam(csStorageOrderCallBackReqDto);
        String documentNo = csStorageOrderCallBackReqDto.getDocumentNo();
        CsOtherStorageOrderEo storageOrder = (CsOtherStorageOrderEo)((ExtQueryChainWrapper)this.csOtherStorageOrderDas.filter().eq((Object)"storage_order_no", (Object)documentNo)).one();
        AssertUtil.isTrue(Objects.nonNull(storageOrder), "\u5355\u636e\u4e0d\u5b58\u5728");
        BigDecimal totalQuantity = this.totalQuantity(csStorageOrderCallBackReqDto.getDetailList(), documentNo, csStorageOrderCallBackReqDto.getBusinessType());
        String nextStatus = this.compareQuantityToGetNextStatus(storageOrder.getTotalQuantity(), totalQuantity, csStorageOrderCallBackReqDto.getBusinessType());
        CsOtherStorageOrderEo updateEo = new CsOtherStorageOrderEo();
        updateEo.setId(storageOrder.getId());
        updateEo.setOrderStatus(nextStatus);
        this.csOtherStorageOrderDas.updateSelective((BaseEo)updateEo);
        List otherDetailEoList = ((ExtQueryChainWrapper)this.csOtherStorageOrderDetailDas.filter().eq((Object)"other_order_no", (Object)documentNo)).list();
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchCreateCsOtherStorageOrder(List<CsOtherStorageOrderComboReqDto> list) {
        this.validParam(list);
        ArrayList<CsOtherStorageOrderEo> otherStorageOrderEoList = new ArrayList<CsOtherStorageOrderEo>();
        ArrayList<CsOtherStorageOrderDetailEo> otherStorageOrderDetailEoList = new ArrayList<CsOtherStorageOrderDetailEo>();
        this.joinParam(list, otherStorageOrderEoList, otherStorageOrderDetailEoList);
        this.csOtherStorageOrderDas.insertBatch(otherStorageOrderEoList);
        this.csOtherStorageOrderDetailDas.insertBatch(otherStorageOrderDetailEoList);
    }

    @Override
    public void editOtherStorageOrder(CsOtherStorageOrderEditReqDto otherStorageOrderEditReqDto) {
        CsOtherStorageOrderEo csOtherStorageOrderEo = new CsOtherStorageOrderEo();
        if (null != otherStorageOrderEditReqDto.getId()) {
            csOtherStorageOrderEo = (CsOtherStorageOrderEo)this.csOtherStorageOrderDas.selectByPrimaryKey(otherStorageOrderEditReqDto.getId());
        } else if (StringUtils.isNotBlank((CharSequence)otherStorageOrderEditReqDto.getStorageOrderNo())) {
            List list = ((ExtQueryChainWrapper)this.csOtherStorageOrderDas.filter().eq((Object)"storage_order_no", (Object)otherStorageOrderEditReqDto.getStorageOrderNo())).list();
            CsOtherStorageOrderEo csOtherStorageOrderEo2 = csOtherStorageOrderEo = CollectionUtils.isNotEmpty((Collection)list) ? (CsOtherStorageOrderEo)list.get(0) : csOtherStorageOrderEo;
        }
        if (null == csOtherStorageOrderEo || null == csOtherStorageOrderEo.getId()) {
            return;
        }
        CsOtherStorageOrderEo csOtherStorageOrderEo1 = new CsOtherStorageOrderEo();
        csOtherStorageOrderEo1.setId(csOtherStorageOrderEo.getId());
        csOtherStorageOrderEo1.setExternalOrderNo(otherStorageOrderEditReqDto.getExternalOrderNo());
        csOtherStorageOrderEo1.setPreOrderNo(otherStorageOrderEditReqDto.getPreOrderNo());
        csOtherStorageOrderEo1.setExtension(otherStorageOrderEditReqDto.getExtension());
        csOtherStorageOrderEo1.setStringCodeResult(otherStorageOrderEditReqDto.getStringCodeResult());
        csOtherStorageOrderEo1.setStringCodeTime(otherStorageOrderEditReqDto.getStringCodeTime());
        this.csOtherStorageOrderDas.updateSelective((BaseEo)csOtherStorageOrderEo1);
    }

    @Override
    public void modifyOtherOut(CsOtherStorageOrderReqDto csOtherStorageOrderReqDto) {
        CsOtherStorageOrderEo csOtherStorageOrderEo = new CsOtherStorageOrderEo();
        DtoHelper.dto2Eo((BaseVo)csOtherStorageOrderReqDto, (BaseEo)csOtherStorageOrderEo);
        if (csOtherStorageOrderReqDto.getId() != null) {
            CsOtherStorageOrderEo eo = (CsOtherStorageOrderEo)this.csOtherStorageOrderDas.selectByPrimaryKey(csOtherStorageOrderReqDto.getId());
            if (eo == null) {
                throw new BizException("\u8be5id\u4e0d\u5b58\u5728");
            }
            this.csOtherStorageOrderDas.updateSelective((BaseEo)csOtherStorageOrderEo);
        }
    }

    @Override
    public List<CsOtherStorageOrderRespDto> queryByParams(CsOtherStorageOrderReqDto reqDto) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5217\u8868\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        CsOtherStorageOrderEo eo = new CsOtherStorageOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        if (StringUtils.isBlank((CharSequence)eo.getStorageOrderNo()) && StringUtils.isBlank((CharSequence)eo.getMergeOrderNo()) && StringUtils.isBlank((CharSequence)eo.getExternalOrderNo())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        }
        List select = this.csOtherStorageOrderDas.select((BaseEo)eo);
        ArrayList<CsOtherStorageOrderRespDto> dtoList = new ArrayList<CsOtherStorageOrderRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            DtoHelper.eoList2DtoList((Collection)select, dtoList, CsOtherStorageOrderRespDto.class);
        }
        return dtoList;
    }

    private void joinParam(List<CsOtherStorageOrderComboReqDto> list, List<CsOtherStorageOrderEo> otherStorageOrderEoList, List<CsOtherStorageOrderDetailEo> otherStorageOrderDetailEoList) {
        for (CsOtherStorageOrderComboReqDto orderComboReqDto : list) {
            CsOtherStorageOrderReqDto reqDto = orderComboReqDto.getCsOtherStorageOrderReqDto();
            List detailList = orderComboReqDto.getDetailList();
            CsOtherStorageOrderEo insertEo = new CsOtherStorageOrderEo();
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)insertEo);
            String code = insertEo.getStorageOrderNo();
            if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(reqDto.getType())) {
                if (StringUtils.isEmpty((CharSequence)code)) {
                    code = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OTHER_STORAGE_ORDER_OUT.getCode()).getCode();
                    insertEo.setStorageOrderNo(code);
                }
                insertEo.setOrderStatus(CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode());
            } else {
                if (StringUtils.isEmpty((CharSequence)code)) {
                    code = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OTHER_STORAGE_ORDER_IN.getCode()).getCode();
                    insertEo.setStorageOrderNo(code);
                }
                insertEo.setOrderStatus(CsOtherStorageOrderStatusEnum.IN.WAIT_AUDIT.getCode());
            }
            this.computerVolumeAndQuantity(detailList, insertEo, code);
            ArrayList eoList = new ArrayList(detailList.size());
            DtoHelper.dtoList2EoList((Collection)detailList, eoList, CsOtherStorageOrderDetailEo.class);
            insertEo.setNoBatch(StringUtils.isBlank((CharSequence)((CsOtherStorageOrderDetailEo)eoList.get(0)).getBatch()) ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
            otherStorageOrderEoList.add(insertEo);
            otherStorageOrderDetailEoList.addAll(eoList);
        }
    }

    private void validParam(List<CsOtherStorageOrderComboReqDto> list) {
        ArrayList<String> preOrderNoList = new ArrayList<String>();
        ArrayList<String> warehouseCodeList = new ArrayList<String>();
        for (CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto : list) {
            CsOtherStorageOrderReqDto storageOrderReqDto = csOtherStorageOrderComboReqDto.getCsOtherStorageOrderReqDto();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)storageOrderReqDto.getPreOrderNo()), "\u524d\u7f6e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)storageOrderReqDto.getType()), "\u5176\u4ed6\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)storageOrderReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            for (CsOtherStorageOrderDetailReqDto detailReqDto : csOtherStorageOrderComboReqDto.getDetailList()) {
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)detailReqDto.getLongCode()), "\u8d27\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isTrue(null != detailReqDto.getQuantity(), "\u8d27\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isTrue(detailReqDto.getQuantity().compareTo(BigDecimal.ZERO) > 0, "\u8d27\u54c1\u6570\u91cf\u9700\u5927\u4e8e0");
            }
            preOrderNoList.add(storageOrderReqDto.getPreOrderNo());
            warehouseCodeList.add(storageOrderReqDto.getWarehouseCode());
        }
        List otherStorageOrderEoList = ((ExtQueryChainWrapper)this.csOtherStorageOrderDas.filter().in((Object)"pre_order_no", preOrderNoList)).list();
        if (CollectionUtils.isNotEmpty((Collection)otherStorageOrderEoList)) {
            for (CsOtherStorageOrderEo csOtherStorageOrderEo : otherStorageOrderEoList) {
                AssertUtil.isTrue(CsOtherStorageOrderStatusEnum.OUT.CANCEL.getCode().equals(csOtherStorageOrderEo.getOrderStatus()), "\u6709\u975e\u53d6\u6d88\u72b6\u6001\u7684\u524d\u7f6e\u5355\u636e" + csOtherStorageOrderEo.getPreOrderNo());
            }
        }
        Map<String, LogicWarehouseEo> map = this.checkLogicWarehouseList(warehouseCodeList);
        for (CsOtherStorageOrderComboReqDto orderComboReqDto : list) {
            CsOtherStorageOrderReqDto csOtherStorageOrderReqDto = orderComboReqDto.getCsOtherStorageOrderReqDto();
            LogicWarehouseEo LogicWarehouseEo2 = map.get(csOtherStorageOrderReqDto.getWarehouseCode());
            AssertUtil.isTrue(Objects.nonNull(LogicWarehouseEo2), csOtherStorageOrderReqDto.getWarehouseCode() + ",\u4ed3\u5e93\u4e0d\u5b58\u5728");
            csOtherStorageOrderReqDto.setOrganization(LogicWarehouseEo2.getCargoEscheatageName());
            csOtherStorageOrderReqDto.setOrganizationId(LogicWarehouseEo2.getOrganizationId());
            csOtherStorageOrderReqDto.setWarehouseName(LogicWarehouseEo2.getWarehouseName());
        }
    }

    private String compareQuantityToGetNextStatus(BigDecimal otherTotalQuantity, BigDecimal totalQuantity, String businessType) {
        int bigger = 1;
        int eq = 0;
        int result = otherTotalQuantity.compareTo(totalQuantity);
        String nextStatus = result == bigger ? (CsPcpBusinessTypeEnum.OTHER_IN.getCode().equals(businessType) ? CsOtherStorageOrderStatusEnum.IN.PORTION_IN.getCode() : CsOtherStorageOrderStatusEnum.OUT.PORTION_OUT.getCode()) : (result == eq ? (CsPcpBusinessTypeEnum.OTHER_IN.getCode().equals(businessType) ? CsOtherStorageOrderStatusEnum.IN.FINISH.getCode() : CsOtherStorageOrderStatusEnum.OUT.FINISH.getCode()) : (CsPcpBusinessTypeEnum.OTHER_IN.getCode().equals(businessType) ? CsOtherStorageOrderStatusEnum.IN.HANG_UP.getCode() : CsOtherStorageOrderStatusEnum.OUT.HANG_UP.getCode()));
        return nextStatus;
    }

    private BigDecimal totalQuantity(List<CsCallBackItemReqDto> detailList, String documentNo, String businessType) {
        BigDecimal totalQuantity;
        block5: {
            List outResultOrderList;
            block4: {
                totalQuantity = new BigDecimal(0);
                for (int i = 0; i < detailList.size(); ++i) {
                    CsCallBackItemReqDto dto = detailList.get(i);
                    totalQuantity = totalQuantity.add(dto.getQuantity());
                }
                if (!CsPcpBusinessTypeEnum.OTHER_IN.getCode().equals(businessType)) break block4;
                List inResultOrderList = ((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)documentNo)).list();
                if (!CollectionUtil.isNotEmpty((Collection)inResultOrderList)) break block5;
                for (InOutResultOrderEo csInResultOrderEo : inResultOrderList) {
                    totalQuantity = totalQuantity.add(csInResultOrderEo.getTotalQuantity());
                }
                break block5;
            }
            if (CsPcpBusinessTypeEnum.OTHER_OUT.getCode().equals(businessType) && CollectionUtil.isNotEmpty((Collection)(outResultOrderList = ((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)documentNo)).list()))) {
                for (InOutResultOrderEo InOutResultOrderEo2 : outResultOrderList) {
                    totalQuantity = totalQuantity.add(InOutResultOrderEo2.getTotalQuantity());
                }
            }
        }
        return totalQuantity;
    }

    private void checkParam(CsStorageOrderCallBackReqDto csStorageOrderCallBackReqDto) {
        if (StringUtils.isNotEmpty((CharSequence)csStorageOrderCallBackReqDto.getWarehouseCode())) {
            this.checkLogicWarehouse(csStorageOrderCallBackReqDto.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)csStorageOrderCallBackReqDto.getDeliveryPhysicsWarehouseCode())) {
            this.checkPhysicsWarehouses(csStorageOrderCallBackReqDto.getWarehouseCode());
        }
        List detailList = csStorageOrderCallBackReqDto.getDetailList();
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)detailList), "\u53c2\u6570\u9519\u8bef,\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        detailList.forEach(d -> AssertUtil.isTrue(d.getQuantity().compareTo(BigDecimal.ZERO) > 0, "\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
        List<String> itemSet = detailList.stream().map(CsCallBackItemReqDto::getLongCode).distinct().collect(Collectors.toList());
        this.checkItem(itemSet);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCsOtherStorageOrder(CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto) {
        logger.info("\u6dfb\u52a0\u5176\u4ed6\u51fa\u5165\u5e93\u5355,\u53c2\u6570{}", (Object)JSON.toJSONString((Object)csOtherStorageOrderComboReqDto));
        CsOtherStorageOrderReqDto reqDto = csOtherStorageOrderComboReqDto.getCsOtherStorageOrderReqDto();
        if (Objects.nonNull(reqDto.getId())) {
            CsOtherStorageOrderEo orderEo = (CsOtherStorageOrderEo)this.csOtherStorageOrderDas.selectByPrimaryKey(reqDto.getId());
            AssertUtil.isTrue(Objects.nonNull(orderEo), "\u5355\u636e\u4e0d\u5b58\u5728");
        }
        this.checkBusinessType(reqDto.getBusinessType());
        LogicWarehouseEo LogicWarehouseEo2 = this.checkLogicWarehouse(reqDto.getWarehouseCode());
        List detailList = csOtherStorageOrderComboReqDto.getDetailList();
        this.checkSku(detailList);
        List<String> itemSet = detailList.stream().map(CsOtherStorageOrderDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        this.checkItem(itemSet);
        CsOtherStorageOrderEo insertEo = new CsOtherStorageOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)insertEo);
        String code = insertEo.getStorageOrderNo();
        if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(reqDto.getType())) {
            insertEo.setOrderStatus(CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode());
            if (StringUtils.isEmpty((CharSequence)code)) {
                code = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OTHER_STORAGE_ORDER_OUT.getCode()).getCode();
                insertEo.setStorageOrderNo(code);
            }
        } else {
            insertEo.setOrderStatus(CsOtherStorageOrderStatusEnum.IN.WAIT_AUDIT.getCode());
            if (StringUtils.isEmpty((CharSequence)code)) {
                code = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OTHER_STORAGE_ORDER_IN.getCode()).getCode();
                insertEo.setStorageOrderNo(code);
            }
        }
        this.computerVolumeAndQuantity(detailList, insertEo, code);
        insertEo.setOrganization(LogicWarehouseEo2.getCargoEscheatageName());
        insertEo.setOrganizationId(LogicWarehouseEo2.getOrganizationId());
        insertEo.setWarehouseName(LogicWarehouseEo2.getWarehouseName());
        insertEo.setNoBatch(StringUtils.isBlank((CharSequence)((CsOtherStorageOrderDetailReqDto)detailList.get(0)).getBatch()) ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
        ArrayList eoList = new ArrayList(detailList.size());
        DtoHelper.dtoList2EoList((Collection)detailList, eoList, CsOtherStorageOrderDetailEo.class);
        if (Objects.nonNull(insertEo.getId())) {
            this.csOtherStorageOrderDas.updateSelective((BaseEo)insertEo);
            CsOtherStorageOrderDetailEo logicDeleteEo = new CsOtherStorageOrderDetailEo();
            logicDeleteEo.setOtherOrderNo(code);
            this.csOtherStorageOrderDetailDas.logicDelete((BaseEo)logicDeleteEo);
        } else {
            this.csOtherStorageOrderDas.insert((BaseEo)insertEo);
        }
        this.csOtherStorageOrderDetailDas.insertBatch(eoList);
        return insertEo.getId();
    }

    private void checkBusinessType(Long businessType) {
        CsBusinessTypeEo csBusinessTypeEo = (CsBusinessTypeEo)this.csBusinessTypeDas.selectByPrimaryKey(businessType);
        AssertUtil.isTrue(Objects.nonNull(csBusinessTypeEo), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CsBusinessTypeStatusEnum.ENABLE.getCode().equals(csBusinessTypeEo.getStatus()), "\u4e1a\u52a1\u7c7b\u578b\u5df2\u7981\u7528");
    }

    private LogicWarehouseEo checkLogicWarehouse(String warehouseCode) {
        LogicWarehouseEo warehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)warehouseCode)).one();
        AssertUtil.isTrue(Objects.nonNull(warehouse), warehouseCode + ",\u4ed3\u5e93\u4e0d\u5b58\u5728");
        return warehouse;
    }

    private Map<String, LogicWarehouseEo> checkLogicWarehouseList(List<String> warehouseCodeList) {
        List logicWarehouseEoList = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodeList)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEoList), JSON.toJSONString(warehouseCodeList) + ",\u4ed3\u5e93\u4e0d\u5b58\u5728");
        Map<String, LogicWarehouseEo> map = logicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, entity -> entity));
        return map;
    }

    private void checkPhysicsWarehouses(String warehouseCode) {
        PhysicsWarehouseEo warehouse = (PhysicsWarehouseEo)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)warehouseCode)).one();
        AssertUtil.isTrue(Objects.nonNull(warehouse), warehouseCode + ",\u4ed3\u5e93\u4e0d\u5b58\u5728");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveCsOtherStorageOrder(CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto) {
        String code;
        logger.info("\u4fdd\u5b58\u5176\u4ed6\u51fa\u5165\u5e93\u5355,\u53c2\u6570{}", (Object)JSON.toJSONString((Object)csOtherStorageOrderComboReqDto));
        List detailList = csOtherStorageOrderComboReqDto.getDetailList();
        if (CollectionUtil.isNotEmpty((Collection)detailList)) {
            this.checkSku(detailList);
        }
        CsOtherStorageOrderReqDto saveDto = csOtherStorageOrderComboReqDto.getCsOtherStorageOrderReqDto();
        this.checkLogicWarehouse(saveDto.getWarehouseCode());
        CsOtherStorageOrderEo insertEo = new CsOtherStorageOrderEo();
        DtoHelper.dto2Eo((BaseVo)saveDto, (BaseEo)insertEo);
        if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(saveDto.getType())) {
            insertEo.setOrderStatus(CsOtherStorageOrderStatusEnum.OUT.WAIT_COMMIT.getCode());
            code = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OTHER_STORAGE_ORDER_OUT.getCode()).getCode();
        } else {
            insertEo.setOrderStatus(CsOtherStorageOrderStatusEnum.IN.WAIT_COMMIT.getCode());
            code = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OTHER_STORAGE_ORDER_IN.getCode()).getCode();
        }
        insertEo.setStorageOrderNo(code);
        if (CollectionUtil.isNotEmpty((Collection)detailList)) {
            List<String> itemSet = detailList.stream().map(CsOtherStorageOrderDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
            this.checkItem(itemSet);
            this.computerVolumeAndQuantity(detailList, insertEo, code);
            ArrayList eoList = new ArrayList(detailList.size());
            DtoHelper.dtoList2EoList((Collection)detailList, eoList, CsOtherStorageOrderDetailEo.class);
            this.csOtherStorageOrderDetailDas.insertBatch(eoList);
        }
        this.csOtherStorageOrderDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    private void computerVolumeAndQuantity(List<CsOtherStorageOrderDetailReqDto> detailList, CsOtherStorageOrderEo updateEo, String code) {
        BigDecimal totalQuantity = new BigDecimal(0);
        BigDecimal totalVolume = new BigDecimal(0);
        for (int i = 0; i < detailList.size(); ++i) {
            CsOtherStorageOrderDetailReqDto dto = detailList.get(i);
            dto.setOtherOrderNo(code);
            totalQuantity = totalQuantity.add(dto.getQuantity());
            if (null == dto.getVolume()) continue;
            totalVolume = totalVolume.add(dto.getQuantity().multiply(dto.getVolume()));
        }
        updateEo.setTotalQuantity(totalQuantity);
        updateEo.setTotalVolume(totalVolume);
    }

    private void checkItem(List<String> itemSet) {
        List itemEoList = this.itemSkuProxy.queryBySkuCodes(itemSet);
        if (itemEoList.size() != itemSet.size()) {
            Map<Object, Object> cargoMap = new HashMap();
            StringBuilder sb = new StringBuilder();
            if (CollectionUtil.isNotEmpty((Collection)itemEoList)) {
                cargoMap = itemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
            }
            for (String itemCode : itemSet) {
                if (cargoMap.containsKey(itemCode)) continue;
                sb.append(itemCode).append(",");
            }
            sb.append("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new BizException(sb.toString());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCsOtherStorageOrder(CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto) {
        logger.info("\u7f16\u8f91\u5176\u4ed6\u51fa\u5165\u5e93\u5355,\u53c2\u6570{}", (Object)JSON.toJSONString((Object)csOtherStorageOrderComboReqDto));
        CsOtherStorageOrderReqDto reqDto = csOtherStorageOrderComboReqDto.getCsOtherStorageOrderReqDto();
        CsOtherStorageOrderEo orderEo = (CsOtherStorageOrderEo)this.csOtherStorageOrderDas.selectByPrimaryKey(reqDto.getId());
        AssertUtil.isTrue(Objects.nonNull(orderEo), "\u5355\u636e\u4e0d\u5b58\u5728");
        List detailList = csOtherStorageOrderComboReqDto.getDetailList();
        this.checkSku(detailList);
        this.checkLogicWarehouse(reqDto.getWarehouseCode());
        List<String> itemSet = detailList.stream().map(CsOtherStorageOrderDetailReqDto::getLongCode).collect(Collectors.toList());
        this.checkItem(itemSet);
        CsOtherStorageOrderEo updateEo = new CsOtherStorageOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)updateEo);
        String code = updateEo.getStorageOrderNo();
        if (StringUtils.isEmpty((CharSequence)code)) {
            code = CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(reqDto.getType()) ? GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OTHER_STORAGE_ORDER_OUT.getCode()).getCode() : GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OTHER_STORAGE_ORDER_IN.getCode()).getCode();
            updateEo.setStorageOrderNo(code);
        }
        this.computerVolumeAndQuantity(detailList, updateEo, code);
        ArrayList eoList = new ArrayList(detailList.size());
        DtoHelper.dtoList2EoList((Collection)detailList, eoList, CsOtherStorageOrderDetailEo.class);
        this.csOtherStorageOrderDas.updateSelective((BaseEo)updateEo);
        CsOtherStorageOrderDetailEo logicDeleteEo = new CsOtherStorageOrderDetailEo();
        logicDeleteEo.setOtherOrderNo(code);
        this.csOtherStorageOrderDetailDas.logicDelete((BaseEo)logicDeleteEo);
        this.csOtherStorageOrderDetailDas.insertBatch(eoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOtherStorageStatus(Long otherStorageOrderId, String status) {
        CsOtherStorageOrderEo updateEo = new CsOtherStorageOrderEo();
        updateEo.setId(otherStorageOrderId);
        updateEo.setOrderStatus(status);
        this.csOtherStorageOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOtherStorage(CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto) {
        logger.info("\u5ba1\u6838\u65f6\u7f16\u8f91\u5176\u4ed6\u51fa\u5165\u5e93\u5355,\u53c2\u6570{}", (Object)JSON.toJSONString((Object)csOtherStorageOrderComboReqDto));
        CsOtherStorageOrderReqDto reqDto = csOtherStorageOrderComboReqDto.getCsOtherStorageOrderReqDto();
        List detailList = csOtherStorageOrderComboReqDto.getDetailList();
        this.checkSku(detailList);
        LogicWarehouseEo LogicWarehouseEo2 = this.checkLogicWarehouse(reqDto.getWarehouseCode());
        reqDto.setWarehouseName(LogicWarehouseEo2.getWarehouseName());
        reqDto.setOrganization(LogicWarehouseEo2.getOrganizationName());
        reqDto.setOrganizationId(LogicWarehouseEo2.getOrganizationId());
        List<String> itemSet = detailList.stream().map(CsOtherStorageOrderDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        this.checkItem(itemSet);
        CsOtherStorageOrderEo updateEo = new CsOtherStorageOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)updateEo);
        String code = updateEo.getStorageOrderNo();
        this.computerVolumeAndQuantity(detailList, updateEo, code);
        reqDto.setTotalQuantity(updateEo.getTotalQuantity());
        ArrayList eoList = new ArrayList(detailList.size());
        DtoHelper.dtoList2EoList((Collection)detailList, eoList, CsOtherStorageOrderDetailEo.class);
        this.csOtherStorageOrderDas.updateSelective((BaseEo)updateEo);
        CsOtherStorageOrderDetailEo logicDeleteEo = new CsOtherStorageOrderDetailEo();
        logicDeleteEo.setOtherOrderNo(code);
        this.csOtherStorageOrderDetailDas.logicDelete((BaseEo)logicDeleteEo);
        eoList.forEach(e -> {
            e.setOtherOrderNo(reqDto.getStorageOrderNo());
            e.setId(null);
        });
        this.csOtherStorageOrderDetailDas.insertBatch(eoList);
    }

    private void checkSku(List<CsOtherStorageOrderDetailReqDto> detailList) {
        AssertUtil.isTrue(CollectionUtil.isNotEmpty(detailList), "\u53c2\u6570\u9519\u8bef,\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        detailList.forEach(d -> AssertUtil.isTrue(d.getQuantity().compareTo(BigDecimal.ZERO) > 0, "\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsOtherStorageOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csOtherStorageOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsOtherStorageOrderRespDto queryById(Long id) {
        CsOtherStorageOrderEo csOtherStorageOrderEo = (CsOtherStorageOrderEo)this.csOtherStorageOrderDas.selectByPrimaryKey(id);
        CsOtherStorageOrderRespDto csOtherStorageOrderRespDto = new CsOtherStorageOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)csOtherStorageOrderEo, (BaseVo)csOtherStorageOrderRespDto);
        if (ObjectUtils.isNotEmpty((Object)csOtherStorageOrderRespDto) && StringUtils.isNotBlank((CharSequence)csOtherStorageOrderRespDto.getStorageOrderNo())) {
            CsOtherStorageOrderDetailEo detailEo = new CsOtherStorageOrderDetailEo();
            detailEo.setOtherOrderNo(csOtherStorageOrderRespDto.getStorageOrderNo());
            List detailEos = this.csOtherStorageOrderDetailDas.select((BaseEo)detailEo);
            ArrayList detailRespDtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)detailEos, detailRespDtoList, CsOtherStorageOrderDetailRespDto.class);
            csOtherStorageOrderRespDto.setDetailRespDtoList(detailRespDtoList);
        }
        return csOtherStorageOrderRespDto;
    }

    @Override
    public CsOtherStorageOrderRespDto queryByStorageOrderNo(String otherOrderNo) {
        CsOtherStorageOrderEo orderEo = (CsOtherStorageOrderEo)((ExtQueryChainWrapper)this.csOtherStorageOrderDas.filter().eq((Object)"storage_order_no", (Object)otherOrderNo)).one();
        AssertUtil.isTrue(Objects.nonNull(orderEo), "\u5355\u636e\u4e0d\u5b58\u5728");
        CsOtherStorageOrderRespDto csOtherStorageOrderRespDto = new CsOtherStorageOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)csOtherStorageOrderRespDto);
        return csOtherStorageOrderRespDto;
    }

    @Override
    public PageInfo<CsOtherStorageOrderRespDto> queryByPage(CsOtherStorageOrderQueryDto csOtherStorageOrderQueryDto, Integer pageNum, Integer pageSize) {
        logger.info("\u5206\u9875\u67e5\u8be2\u5176\u4ed6\u51fa\u5165\u5e93,\u53c2\u6570{}", (Object)JSON.toJSONString((Object)csOtherStorageOrderQueryDto));
        ExtQueryChainWrapper<CsOtherStorageOrderEo> param = this.getQueryEo(csOtherStorageOrderQueryDto);
        PageInfo eoPageInfo = param.select(new String[0]).page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsOtherStorageOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private ExtQueryChainWrapper<CsOtherStorageOrderEo> getQueryEo(CsOtherStorageOrderQueryDto csOtherStorageOrderQueryDto) {
        ExtQueryChainWrapper filter = this.csOtherStorageOrderDas.filter();
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getStartTime())) {
            filter.ge((Object)"create_time", (Object)csOtherStorageOrderQueryDto.getStartTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getEndTime())) {
            filter.le((Object)"create_time", (Object)csOtherStorageOrderQueryDto.getStartTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getOtherStorageNo())) {
            filter.like((Object)"storage_order_no", (Object)csOtherStorageOrderQueryDto.getOtherStorageNo());
        }
        if (null != csOtherStorageOrderQueryDto.getBusinessType()) {
            filter.eq((Object)"business_type", (Object)csOtherStorageOrderQueryDto.getBusinessType());
        }
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getOrganization())) {
            filter.like((Object)"organization", (Object)csOtherStorageOrderQueryDto.getOrganization());
        }
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getWarehouseName())) {
            filter.like((Object)"warehouse_name", (Object)csOtherStorageOrderQueryDto.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getConsignee())) {
            filter.like((Object)"consignee", (Object)csOtherStorageOrderQueryDto.getConsignee());
        }
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getType())) {
            filter.eq((Object)"type", (Object)csOtherStorageOrderQueryDto.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getOrderSrc())) {
            filter.eq((Object)"order_src", (Object)csOtherStorageOrderQueryDto.getOrderSrc());
        }
        if (StringUtils.isNotEmpty((CharSequence)csOtherStorageOrderQueryDto.getOrderStatus())) {
            filter.eq((Object)"order_status", (Object)csOtherStorageOrderQueryDto.getOrderStatus());
        }
        if (CollectionUtils.isNotEmpty((Collection)csOtherStorageOrderQueryDto.getIds())) {
            filter.in((Object)"id", (Collection)csOtherStorageOrderQueryDto.getIds());
        }
        if (csOtherStorageOrderQueryDto.getId() != null) {
            filter.eq((Object)"id", (Object)csOtherStorageOrderQueryDto.getId());
        }
        filter.orderByDesc((Object)"update_time");
        return filter;
    }

    @Override
    public void deleteById(Long id) {
        this.csOtherStorageOrderDas.logicDeleteById(id);
    }

    @Override
    public void submitById(Long id) {
        CsOtherStorageOrderEo orderEo = (CsOtherStorageOrderEo)this.csOtherStorageOrderDas.selectByPrimaryKey(id);
        AssertUtil.isTrue(Objects.nonNull(orderEo), "\u5355\u636e\u4e0d\u5b58\u5728");
        CsOtherStorageOrderEo updateEo = new CsOtherStorageOrderEo();
        updateEo.setId(id);
        if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(orderEo.getType())) {
            updateEo.setOrderStatus(CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode());
        } else {
            updateEo.setOrderStatus(CsOtherStorageOrderStatusEnum.IN.WAIT_AUDIT.getCode());
        }
        this.csOtherStorageOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public List<CsBatchItemRespDto> queryBatchItemByStorageOrderNo(CsBatchItemQueryDto csBatchItemQueryDto) {
        ArrayList<CsBatchItemRespDto> batchItemList = new ArrayList<CsBatchItemRespDto>();
        if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(csBatchItemQueryDto.getType())) {
            List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)csBatchItemQueryDto.getStorageOrderNo())).eq((Object)"sku_code", (Object)csBatchItemQueryDto.getLongCode())).list();
            if (CollectionUtils.isNotEmpty((Collection)eoList)) {
                DtoHelper.eoList2DtoList((Collection)eoList, batchItemList, CsBatchItemRespDto.class);
            }
        } else {
            List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)csBatchItemQueryDto.getStorageOrderNo())).eq((Object)"sku_code", (Object)csBatchItemQueryDto.getLongCode())).list();
            if (CollectionUtils.isNotEmpty((Collection)eoList)) {
                DtoHelper.eoList2DtoList((Collection)eoList, batchItemList, CsBatchItemRespDto.class);
            }
        }
        return batchItemList;
    }

    @Override
    public List<CsOtherStorageOrderRelevanceOrderRespDto> queryOtherStorageOrderRelevanceOrder(String storageOrderNo, String type) {
        return this.queryOutRelevanceOrder(storageOrderNo, type);
    }

    private List<CsOtherStorageOrderRelevanceOrderRespDto> queryOutRelevanceOrder(String storageOrderNo, String type) {
        boolean filterDispatch = PcpBasicInventoryBusinessTypeEnum.TRANSFER_WARHEOUSE.getCode().equals(type);
        List deliveryNoticeOrderList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)storageOrderNo)).ne(filterDispatch, (Object)"business_type", (Object)BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode())).list();
        List outNoticeOrderList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)storageOrderNo)).ne(filterDispatch, (Object)"business_type", (Object)BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode())).list();
        List outResultOrderList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)storageOrderNo)).ne(filterDispatch, (Object)"business_type", (Object)BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode())).list();
        List deliveryResultOrderList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"relevance_no", (Object)storageOrderNo)).ne(filterDispatch, (Object)"business_type", (Object)BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode())).list();
        return this.coverOutToRelevanceRespDto(outNoticeOrderList, outResultOrderList, deliveryNoticeOrderList, deliveryResultOrderList);
    }

    private List<CsOtherStorageOrderRelevanceOrderRespDto> coverOutToRelevanceRespDto(List<InOutNoticeOrderEo> outNoticeOrderList, List<InOutResultOrderEo> outResultOrderList, List<ReceiveDeliveryNoticeOrderEo> deliveryNoticeOrderList, List<ReceiveDeliveryResultOrderEo> deliveryResultOrderList) {
        ArrayList<CsOtherStorageOrderRelevanceOrderRespDto> relevanceList = new ArrayList<CsOtherStorageOrderRelevanceOrderRespDto>();
        if (CollectionUtils.isNotEmpty(outNoticeOrderList)) {
            outNoticeOrderList.forEach(r -> {
                CsOtherStorageOrderRelevanceOrderRespDto relevance = new CsOtherStorageOrderRelevanceOrderRespDto();
                relevance.setId(r.getId());
                relevance.setBusinessType("out".equals(r.getOrderType()) ? CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode() : CsDocumentTypeEnum.IN_NOTICE_ORDER.getCode());
                relevance.setOrderStatus(r.getOrderStatus());
                relevance.setRemark(r.getRemark());
                relevance.setDocumentNo(r.getDocumentNo());
                relevance.setCreateTime(r.getCreateTime());
                relevance.setOrderType(r.getOrderType());
                relevance.setOutWarehouseCode(r.getOutLogicWarehouseCode());
                relevance.setOutWarehouseName(r.getOutLogicWarehouseName());
                relevance.setInWarehouseCode(r.getInLogicWarehouseCode());
                relevance.setInWarehouseName(r.getInLogicWarehouseName());
                relevanceList.add(relevance);
            });
        }
        if (CollectionUtils.isNotEmpty(outResultOrderList)) {
            outResultOrderList.forEach(r -> {
                CsOtherStorageOrderRelevanceOrderRespDto relevance = new CsOtherStorageOrderRelevanceOrderRespDto();
                relevance.setId(r.getId());
                relevance.setBusinessType("out".equals(r.getOrderType()) ? CsDocumentTypeEnum.OUT_RESULT_ORDER.getCode() : CsDocumentTypeEnum.IN_RESULT_ORDER.getCode());
                relevance.setOrderStatus(r.getOrderStatus());
                relevance.setRemark(r.getRemark());
                relevance.setDocumentNo(r.getDocumentNo());
                relevance.setCreateTime(r.getCreateTime());
                relevance.setOrderType(r.getOrderType());
                relevance.setOutWarehouseCode(r.getOutLogicWarehouseCode());
                relevance.setOutWarehouseName(r.getOutLogicWarehouseName());
                relevance.setInWarehouseCode(r.getInLogicWarehouseCode());
                relevance.setInWarehouseName(r.getInLogicWarehouseName());
                relevanceList.add(relevance);
            });
        }
        if (CollectionUtils.isNotEmpty(deliveryNoticeOrderList)) {
            deliveryNoticeOrderList.forEach(r -> {
                CsOtherStorageOrderRelevanceOrderRespDto relevance = new CsOtherStorageOrderRelevanceOrderRespDto();
                relevance.setId(r.getId());
                relevance.setBusinessType("delivery".equals(r.getOrderType()) ? CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode() : CsDocumentTypeEnum.RECEIVE_NOTICE_ORDER.getCode());
                relevance.setOrderStatus(r.getOrderStatus());
                relevance.setRemark(r.getRemark());
                relevance.setDocumentNo(r.getDocumentNo());
                relevance.setCreateTime(r.getCreateTime());
                relevance.setOrderType(r.getOrderType());
                relevance.setOutWarehouseCode(r.getDeliveryLogicWarehouseCode());
                relevance.setOutWarehouseName(r.getDeliveryLogicWarehouseName());
                relevance.setInWarehouseCode(r.getReceiveLogicWarehouseCode());
                relevance.setInWarehouseName(r.getReceiveLogicWarehouseName());
                relevanceList.add(relevance);
            });
        }
        if (CollectionUtils.isNotEmpty(deliveryResultOrderList)) {
            deliveryResultOrderList.forEach(r -> {
                CsOtherStorageOrderRelevanceOrderRespDto relevance = new CsOtherStorageOrderRelevanceOrderRespDto();
                relevance.setId(r.getId());
                relevance.setBusinessType("delivery".equals(r.getOrderType()) ? CsDocumentTypeEnum.DELIVERY_RESULT_ORDER.getCode() : CsDocumentTypeEnum.RECEIVE_RESULT_ORDER.getCode());
                relevance.setOrderStatus(r.getOrderStatus());
                relevance.setRemark(r.getRemark());
                relevance.setDocumentNo(r.getDocumentNo());
                relevance.setCreateTime(r.getCreateTime());
                relevance.setOrderType(r.getOrderType());
                relevance.setOutWarehouseCode(r.getDeliveryLogicWarehouseCode());
                relevance.setOutWarehouseName(r.getDeliveryLogicWarehouseName());
                relevance.setInWarehouseCode(r.getReceiveLogicWarehouseCode());
                relevance.setInWarehouseName(r.getReceiveLogicWarehouseName());
                relevanceList.add(relevance);
            });
        }
        return relevanceList;
    }
}

